#include <all.h>

#define ver(...) { \
	if (cpu_verbose) { \
		SDL_LogVerbose(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__); \
	} \
}

#define CYCLES 10

#define RESET_PC 0x100000
#define RESET_SP 0x100000

bool cpu_verbose = false;
static bool reset = true;

uint32_t m68k_read_disassembler_8(uint32_t addr)
{
	ver("mem rd 0x%08x:8", addr);
	return 0;
}

uint32_t m68k_read_disassembler_16(uint32_t addr)
{
	ver("mem rd 0x%08x:16", addr);
	return 0;
}

uint32_t m68k_read_disassembler_32(uint32_t addr)
{
	ver("mem rd 0x%08x:32", addr);
	return 0;
}

uint32_t m68k_read_memory_8(uint32_t addr)
{
	ver("mem rd 0x%08x:8", addr);
	return 0;
}

uint32_t m68k_read_memory_16(uint32_t addr)
{
	ver("mem rd 0x%08x:16", addr);

	if (addr < 0x100000) {
	}

	if (addr < 0x110000) {
		return 0x60fe;
	}

	return 0;
}

uint32_t m68k_read_memory_32(uint32_t addr)
{
	ver("mem rd 0x%08x:32", addr);

	if (reset) {
		if (addr == 0) {
			return RESET_SP;
		}

		if (addr == 4) {
			reset = false;
			return RESET_PC;
		}

		fail("invalid reset sequence");
	}

	return 0;
}

void m68k_write_memory_8(uint32_t addr, uint32_t val)
{
	ver("mem wr 0x%08x:8 0x%02x", addr, val);
}

void m68k_write_memory_16(uint32_t addr, uint32_t val)
{
	ver("mem wr 0x%08x:16 0x%04x", addr, val);
}

void m68k_write_memory_32(uint32_t addr, uint32_t val)
{
	ver("mem wr 0x%08x:32 0x%08x", addr, val);
}

void cpu_loop(void)
{
	ver("entering CPU loop");

	m68k_init();
	m68k_set_cpu_type(M68K_CPU_TYPE_68000);
	m68k_pulse_reset();

	for (int32_t i = 0; i < 5; ++i) {
		m68k_execute(CYCLES);
	}
}
