/*
 *  Copyright (C) 2017 The Contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  A copy of the GNU General Public License can be found in the file
 *  "gpl.txt" in the top directory of this repository.
 */

#include <all.h>

#define ver(...) _ver(fdd_verbose, 0, __VA_ARGS__)
#define ver2(...) _ver(fdd_verbose, 1, __VA_ARGS__)
#define ver3(...) _ver(fdd_verbose, 2, __VA_ARGS__)

int32_t fdd_verbose = 0;

#define N_CYL 80
#define N_SID 2
#define N_SEC 18
#define SZ_SEC 512

#define SZ_DISK (N_CYL * N_SID * N_SEC * SZ_SEC)

static uint8_t image[SZ_DISK];

void fdd_init(void)
{
	ver("fdd init");
	inf("loading disk image file %s", disk);

	SDL_RWops *ops = SDL_RWFromFile(disk, "rb");

	if (ops == NULL) {
		fail("error while opening disk image file %s", disk);
	}

	size_t loaded = 0;

	while (loaded < SZ_DISK) {
		size_t n_rd = SDL_RWread(ops, image + loaded, 1, SZ_DISK - loaded);

		if (n_rd == 0) {
			fail("error while reading disk image file %s", disk);
		}

		loaded += n_rd;
	}

	SDL_RWclose(ops);
}

void fdd_quit(void)
{
	ver("fdd quit");
}

bool fdd_exec(void)
{
	ver3("fdd exec");
	return false;
}

uint32_t fdd_read(uint32_t off, int32_t sz)
{
	ver2("fdd rd %u:%d", off, sz * 8);
	return 0;
}

void fdd_write(uint32_t off, int32_t sz, uint32_t val)
{
	ver2("fdd wr %u:%d 0x%0*x", off, sz * 8, sz * 2, val);
}
