| ------------------------------------------------------------------------------
| hwdefs.s --  External definitions of Buchla 700 I/O addresses
| Version 14 -- 1988-08-15 -- D.N. Lynx Crowe
| ------------------------------------------------------------------------------
		.text

		.xdef	_io_time,_io_lcd,_io_ser,_io_midi
		.xdef	_io_disk,_io_tone,_io_leds,_io_kbrd
		.xdef	_io_vreg,_io_vraw,_io_vram,_io_fpu
		.xdef	_lcd_a0,_lcd_a1

		.xdef	_v_regs,_v_odtab,_v_actab
		.xdef	_v_ct0
		.xdef	_v_gt1
		.xdef	_v_score,_v_cgtab

		.xdef	_v_curs0,_v_curs1,_v_curs2,_v_curs3
		.xdef	_v_curs4,_v_curs5,_v_curs6,_v_curs7
		.xdef	_v_kbobj,_v_lnobj,_v_tcur
		.xdef	_v_win0
		.xdef	_v_cur

		.xdef	_fc_sw,_fc_val

| ------------------------------------------------------------------------------

| Hardware base addresses
| -----------------------
_io_fpu		=	0x180000	| FPU base address

VB		=	0x200000	| VSDD base address

_io_time	=	0x3A0001	| Timer chip
_io_lcd		=	0x3A4001	| LCD controller
_io_ser		=	0x3A8001	| Serial ports  (RS232)
_io_midi	=	0x3AC001	| MIDI ports
_io_disk	=	0x3B0001	| Disk controller
_io_tone	=	0x3B4001	| Sound generator chip
_io_leds	=	0x3B8001	| LED driver
_io_kbrd	=	0x3BC001	| Keyboard / panel processor

_lcd_a0		=	_io_lcd		| LCD port a0
_lcd_a1		=	_io_lcd+2	| LCD port a1

		.page

| Video definitions
| -----------------
_io_vreg	=	VB		| Relocated video registers after setup
_io_vraw	=	VB+0x400	| Raw video registers at RESET
_io_vram	=	VB		| Video RAM base address

| Name			Offset		  Usage			       Bank
| -------		---------	  -------------------------    ----
_v_regs		=	VB		| Video registers	       0,1

_v_odtab	=	VB+128		| Object Descriptor Table	0
_v_actab	=	VB+256		| Access Table			0
_v_ct0		=	VB+1024		| Character Text-0		0
_v_gt1		=	VB+1304		| Graphics Text-1		0
_v_score	=	VB+8192		| Score object			0
_v_cgtab	=	VB+122880	| Character Generator Table	0

_v_curs0	=	VB+1024		| Cursor object 0  (arrow ULE)	1
_v_curs1	=	VB+1152		| Cursor object 1  (arrow ULO)	1
_v_curs2	=	VB+1280		| Cursor object 2  (arrow URE)	1
_v_curs3	=	VB+1408		| Cursor object 3  (arrow URO)	1
_v_curs4	=	VB+1536		| Cursor object 4  (arrow LLE)	1
_v_curs5	=	VB+1664		| Cursor object 5  (arrow LLO)	1
_v_curs6	=	VB+1792		| Cursor object 6  (arrow LRE)	1
_v_curs7	=	VB+1920		| Cursor object 7  (arrow LRO)	1
_v_tcur		=	VB+2048		| Typewriter cursor		1
_v_kbobj	=	VB+2880		| Keyboard object		1
_v_lnobj	=	VB+4672		| Line object			1
_v_cur		=	VB+6464		| Underline cursor		1
_v_win0		=	VB+16384	| Window-0 object		1

| BIOS RAM definitions
| --------------------
| WARNING: the following addresses must match those of the corresponding
| variables defined in bios.s or chaos is guaranteed.

_fc_sw		=	0x420		| word - Frame counter switch
_fc_val		=	0x422		| long - Frame counter value

		.end
