#!/usr/bin/env python3

from sys import stdout
from pycparser import c_ast, c_generator, parse_file
from re import sub

cross_gcc = "/opt/cross-m68k/bin/m68k-none-elf-gcc"

class Visitor(c_ast.NodeVisitor):
    gen = c_generator.CGenerator()

    def __init__(self):
        self.path = None
        self.decl = {}

    def visit_Typedef(self, node):
        return

    def visit_Decl(self, node):
        if node.coord.file != self.path or node.name is None:
            return

        node.init = None
        node.storage = [x for x in node.storage if
                        x != "static" and
                        x != "extern"]

        decl = sub(r"\[[^\]]+\]", "[]", self.gen.visit(node))

        if node.name not in self.decl:
            self.decl[node.name] = decl

        elif self.decl[node.name] != decl:
            raise Exception("mismatch for {} in {}:{}: {} <-> {}". \
                            format(node.name, node.coord.file, node.coord.line, \
                                   self.decl[node.name], decl))

    def visit_FuncDef(self, node):
        if node.coord.file != self.path:
            return

        self.visit_Decl(node.decl)

    def visit_path(self, path, ast):
        self.path = path
        self.visit(ast)
        self.path = None

path_ast = []

with open("misc/c-files.txt", "r") as f:
    for path in f:
        path = path.rstrip()

        if path == "ram/wdfield.c": # breaks pycparser
            continue

        stdout.write("parsing {}                    \r".format(path))
        stdout.flush()

        ast = parse_file(path, use_cpp = True, cpp_path = cross_gcc,
                         cpp_args = ["-E", "-I", "include", "-include", "predef.h"])
        path_ast.append((path, ast))
        # ast.show()

    print("")

vis = Visitor()

for (path, ast) in path_ast:
    stdout.write("visiting {}                    \r".format(path))
    stdout.flush()

    vis.visit_path(path, ast)

print("")
