/*
   =============================================================================
	sprintf.c -- sprintf function
	Version 2 -- 1987-06-11 -- D.N. Lynx Crowe
   =============================================================================
*/

#include "stdarg.h"

extern long	dofmt_();

static char	*buff;
static int	spsub();

/*
   =============================================================================
	sprintf(str, fmt, args) -- format args into str according to fmt
   =============================================================================
*/

long sprintf(char *str, char *fmt, ...)
{
	register long count;
	va_list aptr;

	buff = str;
	va_start(aptr, fmt);
	count = dofmt_(spsub, fmt, aptr);
	va_end(aptr);
	*buff = '\0';
	return(count);
}

/*
   =============================================================================
	spsub(c) - put c into the output string
   =============================================================================
*/

static
int
spsub(c)
char c;
{
	return((*buff++ = c) & 0xFF);
}
