/*
   =============================================================================
	scfield.c -- score editor field setup
	Version 62 -- 1989-11-15 -- D.N. Lynx Crowe
   =============================================================================
*/

#include "stddefs.h"
#include "fields.h"
#include "vsdd.h"
#include "graphdef.h"
#include "hwdefs.h"
#include "panel.h"
#include "macros.h"
#include "score.h"
#include "scfns.h"
#include "curpak.h"

#include "midas.h"
#include "scdsp.h"

#define	PCENTER		256L

/* functions defined elsewhere */

extern	void	*memset(void *vp, int8_t c, int16_t n);

extern	void	cxkstd(void);
extern	void	cykstd(void);
extern	void	select(void);
extern	int16_t	oktode(struct s_entry *ep);
extern	int16_t	stdctp3(void);
extern	void	stddkey(int16_t k);
extern	void	nokey(void);
extern	void	stdmkey(void);

extern	int16_t	et_strn(int16_t n);
extern	int16_t	ef_strn(int16_t n);
extern	int16_t	rd_strn(int16_t n);
extern	int16_t	nd_strn(int16_t n, int16_t k);
extern	int16_t	et_snbt(int16_t n);
extern	int16_t	ef_snbt(int16_t n);
extern	int16_t	rd_snbt(int16_t n);
extern	int16_t	nd_snbt(int16_t n, int16_t k);

extern	int16_t	et_ioas(int16_t n);
extern	int16_t	ef_ioas(int16_t n);
extern	int16_t	rd_ioas(int16_t n);
extern	int16_t	nd_ioas(int16_t n, int16_t k);
extern	int16_t	et_tune(int16_t n);
extern	int16_t	ef_tune(int16_t n);
extern	int16_t	rd_tune(int16_t n);
extern	int16_t	nd_tune(int16_t n, int16_t k);
extern	int16_t	et_tmpo(int16_t n);
extern	int16_t	ef_tmpo(int16_t n);
extern	int16_t	rd_tmpo(int16_t n);
extern	int16_t	nd_tmpo(int16_t n, int16_t k);
extern	int16_t	et_intp(int16_t n);
extern	int16_t	ef_intp(int16_t n);
extern	int16_t	rd_intp(int16_t n);
extern	int16_t	nd_intp(int16_t n, int16_t k);

extern	int16_t	et_inst(int16_t n);
extern	int16_t	ef_inst(int16_t n);
extern	int16_t	rd_inst(int16_t n);
extern	int16_t	nd_inst(int16_t n, int16_t k);
extern	int16_t	et_trns(int16_t n);
extern	int16_t	ef_trns(int16_t n);
extern	int16_t	rd_trns(int16_t n);
extern	int16_t	nd_trns(int16_t n, int16_t k);
extern	int16_t	et_dyn(int16_t n);
extern	int16_t	ef_dyn(int16_t n);
extern	int16_t	rd_dyn(int16_t n);
extern	int16_t	nd_dyn(int16_t n, int16_t k);
extern	int16_t	et_loc(int16_t n);
extern	int16_t	ef_loc(int16_t n);
extern	int16_t	rd_loc(int16_t n);
extern	int16_t	nd_loc(int16_t n, int16_t k);
extern	int16_t	et_vel(int16_t n);
extern	int16_t	ef_vel(int16_t n);
extern	int16_t	rd_vel(int16_t n);
extern	int16_t	nd_vel(int16_t n, int16_t k);

extern	int16_t	et_res1(int16_t n);
extern	int16_t	ef_res1(int16_t n);
extern	int16_t	rd_res1(int16_t n);
extern	int16_t	nd_res1(int16_t n, int16_t k);
extern	int16_t	et_aval(int16_t n);
extern	int16_t	ef_aval(int16_t n);
extern	int16_t	rd_aval(int16_t n);
extern	int16_t	nd_aval(int16_t n, int16_t k);
extern	int16_t	et_agrp(int16_t n);
extern	int16_t	ef_agrp(int16_t n);
extern	int16_t	rd_agrp(int16_t n);
extern	int16_t	nd_agrp(int16_t n, int16_t k);

extern	int16_t	et_scor(int16_t n);
extern	int16_t	ef_scor(int16_t n);
extern	int16_t	rd_scor(int16_t n);
extern	int16_t	nd_scor(int16_t n, int16_t k);

/* forward references */

int16_t	et_null(int16_t n);
int16_t	ef_null(int16_t n);
int16_t	rd_null(int16_t n);
int16_t	nd_null(int16_t n, int16_t k);
void	sdcxu(void);
void	sdcyu(void);
void	sdxkey(void);
void	sdmkey(void);
int16_t	scntfld(int16_t k);

extern	int16_t delnote(void);
extern	int16_t sc_refr(int32_t t);
extern	void curset(struct curpak *s);
extern	void ds_anrs(void);
extern	void ds_anvl(void);
extern	void dsgmode(int16_t n);
extern	void dsgstat(int16_t n);
extern	void dsgtme(int16_t n);
extern	void dsvmode(int16_t n);
extern	void dswin(int16_t n);
extern	void sdmenu(int16_t n);
extern	void vtcxupd(void);
extern	void vtcyupd(void);

/* 
*/

/* variables defined elsewhere */

extern	int16_t	ancmsw;
extern	int16_t	angroup;
extern	int16_t	astat;
extern	int16_t	clkrun;
extern	int16_t	cmfirst;
extern	int16_t	cmtype;
extern	int16_t	curhold;
extern	int16_t	cxrate;
extern	int16_t	cxval;
extern	int16_t	cyrate;
extern	int16_t	cyval;
extern	int16_t	hcwval;
extern	int16_t	insmode;
extern	int16_t	oldpk;
extern	int16_t	oldsl;
extern	int16_t	pkctrl;
extern	int16_t	recsw;
extern	int16_t	scmctl;
extern	int16_t	sdmctl;
extern	int16_t	sliders;
extern	int16_t	stccol;
extern	int16_t	stcrow;
extern	int16_t	thcwval;
extern	int16_t	tvcwval;
extern	int16_t	vcwval;
extern	int16_t	vtccol;
extern	int16_t	vtcrow;
extern	int16_t	vtxval;
extern	int16_t	vtyval;

extern	int32_t	ctime;
extern	int32_t	t_ins;

extern	int16_t	crate1[];
extern	int16_t	ehdlist[];
extern	int16_t	grpmode[];
extern	int16_t	grpstat[];
extern	int16_t	grptmap[];
extern	int16_t	sdmlim[][4];
extern	int16_t	varmode[8][16];

extern	LPF	(*swpt)[];
extern	LPF	(*oldsw)[];

extern	struct	selbox	*csbp;

extern	struct	selbox	sdboxes[];

extern	struct	s_entry	*peg;

/* 
*/

struct	fet	sc_fet1[] = {

	{ 0,  2,  4, 0x0000, et_strn, ef_strn, rd_strn, nd_strn},
	{ 0, 11, 15, 0x0000, et_snbt, ef_snbt, rd_snbt, nd_snbt},

	{17, 11, 12, 0x0000, et_ioas, ef_ioas, rd_ioas, nd_ioas},
	{17, 19, 19, 0x0000, et_tune, ef_tune, rd_tune, nd_tune},
	{17, 27, 29, 0x0000, et_tmpo, ef_tmpo, rd_tmpo, nd_tmpo},
	{17, 35, 38, 0x0000, et_intp, ef_intp, rd_intp, nd_intp},

	{18,  7,  8,      0, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 12, 13,      1, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 17, 18,      2, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 22, 23,      3, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 27, 28,      4, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 32, 33,      5, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 37, 38,      6, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 42, 43,      7, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 47, 48,      8, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 52, 53,      9, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 57, 58,     10, et_inst, ef_inst, rd_inst, nd_inst},
	{18, 62, 63,     11, et_inst, ef_inst, rd_inst, nd_inst},

	{19,  5,  8,      0, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 10, 13,      1, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 15, 18,      2, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 20, 23,      3, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 25, 28,      4, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 30, 33,      5, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 35, 38,      6, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 40, 43,      7, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 45, 48,      8, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 50, 53,      9, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 55, 58,     10, et_trns, ef_trns, rd_trns, nd_trns},
	{19, 60, 63,     11, et_trns, ef_trns, rd_trns, nd_trns},

/* 
*/

	{20,  6,  6,      0, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20,  8,  8,      0, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 11, 11,      1, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 13, 13,      1, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 16, 16,      2, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 18, 18,      2, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 21, 21,      3, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 23, 23,      3, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 26, 26,      4, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 28, 28,      4, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 31, 31,      5, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 33, 33,      5, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 36, 36,      6, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 38, 38,      6, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 41, 41,      7, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 43, 43,      7, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 46, 46,      8, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 48, 48,      8, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 51, 51,      9, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 53, 53,      9, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 56, 56,     10, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 58, 58,     10, et_loc,  ef_loc,  rd_loc,  nd_loc},

	{20, 61, 61,     11, et_dyn,  ef_dyn,  rd_dyn,  nd_dyn},
	{20, 63, 63,     11, et_loc,  ef_loc,  rd_loc,  nd_loc},

/* 
*/

	{21,  6,  8,      0, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 11, 13,      1, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 16, 18,      2, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 21, 23,      3, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 26, 28,      4, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 31, 33,      5, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 36, 38,      6, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 41, 43,      7, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 46, 48,      8, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 51, 53,      9, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 56, 58,     10, et_vel,  ef_vel,  rd_vel,  nd_vel},
	{21, 61, 63,     11, et_vel,  ef_vel,  rd_vel,  nd_vel},


	{23,  6,  6,      0, et_res1, ef_res1, rd_res1, nd_res1},
	{23,  8, 12,      0, et_aval, ef_aval, rd_aval, nd_aval},

	{23, 15, 15,      1, et_res1, ef_res1, rd_res1, nd_res1},
	{23, 17, 21,      1, et_aval, ef_aval, rd_aval, nd_aval},

	{23, 24, 24,      2, et_res1, ef_res1, rd_res1, nd_res1},
	{23, 26, 30,      2, et_aval, ef_aval, rd_aval, nd_aval},

	{23, 33, 33,      3, et_res1, ef_res1, rd_res1, nd_res1},
	{23, 35, 39,      3, et_aval, ef_aval, rd_aval, nd_aval},

	{23, 42, 42,      4, et_res1, ef_res1, rd_res1, nd_res1},
	{23, 44, 48,      4, et_aval, ef_aval, rd_aval, nd_aval},

	{23, 51, 51,      5, et_res1, ef_res1, rd_res1, nd_res1},
	{23, 53, 57,      5, et_aval, ef_aval, rd_aval, nd_aval},

	{23, 61, 62,      0, et_agrp, ef_agrp, rd_agrp, nd_agrp},

	{24,  7,  8, 0x0000, et_scor, ef_scor, rd_scor, nd_scor},
	{24, 10, 25, 0x0000, et_null, ef_null, rd_null, nd_null},


	{ 0,  0,  0, 0x0000, FN_NULL, FN_NULL, FN_NULL, FN_NULL}
};

/* 
*/

struct curpak sc_flds = {

	stdctp3,	/* curtype */
	nokey,		/* premove */
	nokey,		/* pstmove */
	cxkstd,		/* cx_key */
	cykstd,		/* cy_key */
	sdcxu,		/* cx_upd */
	sdcyu,		/* cy_upd */
	nokey,		/* xy_up */
	nokey,		/* xy_dn */
	sdxkey,		/* x_key */
	select,		/* e_key */
	sdmkey,		/* m_key */
	stddkey,	/* d_key */
	scntfld,	/* not_fld */
	sc_fet1,	/* curfet */
	sdboxes,	/* csbp */
	crate1,		/* cratex */
	crate1,		/* cratey */
	CT_GRAF,	/* cmtype */
	C1X,		/* cxval */
	C1Y		/* cyval */
};

/* 
*/

/*
   =============================================================================
	et_null() .. nd_null() -- null data entry key processors
   =============================================================================
*/

int16_t et_null(int16_t n)
{
	return(SUCCESS);
}

int16_t ef_null(int16_t n)
{
	return(SUCCESS);
}

int16_t rd_null(int16_t n)
{
	return(SUCCESS);
}

int16_t nd_null(int16_t n, int16_t k)
{
	return(SUCCESS);
}

/* 
*/

/*
   =============================================================================
	istart() -- start insert mode
   =============================================================================
*/

void istart(void)
{
	register struct s_entry *ep, *pp, *tp;

	if (insmode)				/* can't already be inserting */
		return;

	ep    = ep_adj(p_cur, 1, t_cur);	/* locate tail */

	if (EV_SCORE EQ (0x007F & ep->e_type))	/* skip begin score event */
		ep = ep->e_fwd;

	if (EV_FINI EQ (0x007F & ep->e_type))	/* null if at end of score */
		return;

	tp = scores[curscor]->e_bak;		/* locate end of score */
	pp = ep->e_bak;				/* locate end of head */

	ep->e_bak = E_NULL;			/* unhook tail from head */
	pp->e_fwd = tp;				/* unhook head from tail */
	(tp->e_bak)->e_fwd = E_NULL;		/* unhook tail from end */

	tp->e_bak = pp;				/* connect end to head */

	t_ins = t_cur;				/* record tail time */
	peg   = ep;				/* hang tail on peg */

	p_cur = ep_adj(pp, 0, t_cur);		/* adjust p_cur */
	p_ctr = p_cur;				/* adjust p_ctr */
	p_bak = ep_adj(p_cur, 0, t_bak);	/* adjust p_bak */
	p_fwd = ep_adj(p_cur, 0, t_fwd);	/* adjust p_fwd */

	insmode = TRUE;
}

/* 
*/

/*
   =============================================================================
	icancel() -- cancel insert mode
   =============================================================================
*/

void icancel(void)
{
	register struct s_entry *ep, *tp, *rp;
	struct s_entry *pp;
	int32_t endtime;

	if (NOT insmode)
		return;

	tp = scores[curscor]->e_bak;		/* locate end of score */
	pp = tp->e_bak;				/* locate end of head */

	endtime = pp->e_time;			/* find last time in score */

	if (t_cur > endtime)			/* use max of t_cur, endtime */
		endtime = t_cur;

	rp = peg;				/* point at start of tail */

	while (E_NULL NE rp) {			/* scan each event in the tail */

		ep = rp;			/* update pointers */
		rp = ep->e_fwd;

		ep->e_time = (ep->e_time - t_ins) + endtime;	/* adjust time */
	}

	ep->e_fwd = tp;				/* connect tail to end */
	tp->e_bak = ep;				/* connect end to tail */

	pp->e_fwd  = peg;			/* connect head to tail */
	peg->e_bak = pp;			/* connect tail to head */

	p_cur = ep_adj(pp, 0, t_cur);		/* adjust p_cur */
	p_ctr = p_cur;				/* adjust p_ctr */
	p_bak = ep_adj(p_cur, 0, t_bak);	/* adjust p_bak */
	p_fwd = ep_adj(p_cur, 0, t_fwd);	/* adjust p_fwd */

	insmode = FALSE;
}

/* 
*/

/*
   =============================================================================
	sdcxu() -- score cursor x update processing
   =============================================================================
*/

void sdcxu(void)
{
	if (sdmctl EQ 0) {		/* typewriter up */

		vtcxupd();

	} else if (sdmctl > 0) {	/* menu up */

		vtccol = XTOC(vtxval += cxrate);

		if (vtccol > sdmlim[sdmctl][3])
			vtxval = CTOX(vtccol = sdmlim[sdmctl][3]);
		else if (vtccol < sdmlim[sdmctl][1])
			vtxval = CTOX(vtccol = sdmlim[sdmctl][1]);

	} else {		/* no menu showing */

		cxval += cxrate;

		if (cxval > CXMAX)
			cxval = CXMAX;
		else if (cxval < 0)
			cxval = 0;
	}

	return;
}

/* 
*/

/*
   =============================================================================
	sdcyu() -- score cursor y update processing
   =============================================================================
*/

void sdcyu(void)
{
	if (sdmctl EQ 0) {

		vtcyupd();

	} else if (sdmctl > 0) {	/* menu up */

		vtcrow = YTOR(vtyval += cyrate);

		if (vtcrow < sdmlim[sdmctl][0])
			vtyval = RTOY(vtcrow = sdmlim[sdmctl][0]);
		else if (vtcrow > sdmlim[sdmctl][2])
			vtyval = RTOY(vtcrow = sdmlim[sdmctl][2]);

	} else {		/* no menu showing */

		cyval += cyrate;

		if (cyval > CYMAX)
			cyval = CYMAX;
		else if (cyval < 0)
			cyval = 0;

	}

	return;
}

/* 
*/

/*
   =============================================================================
	scntfld() -- not-in-field data entry key processing
   =============================================================================
*/

int16_t scntfld(int16_t k)
{
	register int16_t grp, fnc, var;

	if (NOT astat)
		return(FAILURE);

	if (stcrow EQ 18) {		/* group status or mode */

		if (stccol LT 5)
			return(FAILURE);

		grp = (stccol - 5) / 5;		/* group */
		fnc = (stccol - 5) % 5;		/* status or mode */

		if (fnc EQ 0) {			/* status */

			if (k EQ 8) {		/* '-' */

				grpstat[grp] = FALSE;
				dsgstat(grp);
				return(SUCCESS);

			} else if (k EQ 9) {	/* '+' */

				grpstat[grp] = TRUE;
				dsgstat(grp);
				return(SUCCESS);

			} else
				return(FAILURE);
/* 
*/
		} else if (fnc EQ 1) {		/* mode */

			if (k EQ 8) {		/* '-' */

				grpmode[grp] = 0;
				dsgmode(grp);
				return(SUCCESS);

			} else if (k EQ 9) {	/* '+' */

				if (++grpmode[grp] GT 1)
					grpmode[grp] = 2;

				dsgmode(grp);
				return(SUCCESS);

			} else
				return(FAILURE);

		} else
			return(FAILURE);
/* 
*/
	} else if (stcrow EQ 22) {	/* analog variables */

		if (stccol < 5)
			return(FAILURE);

		var = (stccol - 5) / 9;		/* variable */
		fnc = (stccol - 5) % 9;		/* field column */
		grp = abs(angroup) - 1;		/* group */

		if (fnc EQ 0) {			/* mode column */

			if (k EQ 8) {		/* '-' */

				varmode[var][grp] = 0;
				dsvmode(var);
				return(SUCCESS);

			} else if (k EQ 9) {	/* '+' */

				if (++varmode[var][grp] GT 1)
					varmode[var][grp] = 2;

				dsvmode(var);
				return(SUCCESS);
			}
		}
	}

	return(FAILURE);
}

/* 
*/

/*
   =============================================================================
	cp2time() -- check cursor position and convert it to time

	Sets 'ctime' if the cursor x argument, 'cx',  is within the score.
   =============================================================================
*/

int16_t cp2time(int16_t cx)
{
	register int32_t ct;

	ct = t_cur + ((int32_t)cx - PCENTER);

	if (ct < 0L)			/* if out of score time range */
		return(FALSE);		/* ... return FALSE */

	ctime = ct;			/* set ctime */
	return(TRUE);			/* ... and return TRUE */
}

/* 
*/

/*
   =============================================================================
	delevts() -- delete record enabled non-note events at current time
   =============================================================================
*/

int16_t delevts(int16_t etp, int32_t thetime)
{
	register struct s_entry *ep, *np;
	register int16_t et;
	register int16_t rc;
	register int16_t dsw;

	rc = FALSE;				/* intialize return code */

	ep = ep_adj(p_cur, 1, thetime);		/* start at left end of chain */

/* 
*/
	while (ep->e_time EQ thetime) {		/* for each event at ctime ... */

		np = ep->e_fwd;			/* get next event pointer */
		et = 0x007F & ep->e_type;	/* get type */
		dsw = oktode(ep);		/* get deletion status */

		if (dsw AND	/* delete event if it's deletable ... */
		    ((etp EQ -1) OR (et EQ etp))) {  /* ... and the right kind */

			rc = TRUE;

			if (-1 NE ehdlist[et])	/* if this is a header event ... */
				eh_rmv(ep, ehdlist[et]);  /* remove from hdr list */

			/* fix up any effected pointers */

			if (p_bak EQ ep)
				p_bak = np;

			if (p_cur EQ ep)
				p_cur = np;

			if (p_ctr EQ ep)
				p_ctr = np;

			if (p_fwd EQ ep)
				p_fwd = np;

			e_del(e_rmv(ep));	/* delete the event */
		}

		ep = np;
	}

	if (rc)				/* if anything was deleted ... */
		sc_refr(t_cur);		/* ... update the display */

	return(rc);
}

/* 
*/

/*
   =============================================================================
	deladat() -- delete analog varaible data
   =============================================================================
*/

int16_t deladat(void)
{
	register struct s_entry *ep, *rp;
	register int16_t grp, rc, var, vc, vn;

	rc = FALSE;

	if (stccol < 6)				/* pointing at var ? */
		return(rc);

	vn = (stccol - 6) / 9;			/* variable number */
	vc = (stccol - 6) % 9;			/* variable column */

	ep = ep_adj(p_cur, 1, t_cur);		/* start at left end of chain */

	if (vc EQ 0) {				/* resolution */

		while (t_cur EQ ep->e_time) {

			rp = ep->e_fwd;

			if (EV_ANRS EQ (0x007F & ep->e_type)) {

				grp = 0x000F & ep->e_data1;
				var = 0x000F & (ep->e_data1 >> 4);

				if ((var EQ vn) AND grpstat[grp] AND
				    (2 EQ (ancmsw ? varmode[var][grp] :
				     grpmode[grp]))) {

					/* fix pointers */

					if (p_bak EQ ep)
						p_bak = rp;

					if (p_cur EQ ep)
						p_cur = rp;

					if (p_ctr EQ ep)
						p_ctr = rp;

					if (p_fwd EQ ep)
						p_fwd = rp;

					/* delete event */

					eh_rmv(ep, EH_ANRS);
					e_del(e_rmv(ep));
					rc = TRUE;
				}
			}

			ep = rp;		/* next event */
		}
/* 
*/
	} else if ((vc GE 2) AND (vc LE 6)) {	/* value */

		while (t_cur EQ ep->e_time) {

			rp = ep->e_fwd;

			if (EV_ANVL EQ (0x007F & ep->e_type)) {

				grp = 0x000F & ep->e_data1;
				var = 0x000F & (ep->e_data1 >> 4);

				if ((var EQ vn) AND grpstat[grp] AND
				    (2 EQ (ancmsw ? varmode[var][grp] :
				     grpmode[grp]))) {

					/* fix pointers */

					if (p_bak EQ ep)
						p_bak = rp;

					if (p_cur EQ ep)
						p_cur = rp;

					if (p_ctr EQ ep)
						p_ctr = rp;

					if (p_fwd EQ ep)
						p_fwd = rp;

					e_del(e_rmv(ep));	/* delete */
					rc = TRUE;
				}
			}

			ep = rp;	/* next event */
		}
	}

	if (rc) {			/* refresh the screen if it changed */

		sc_refr(fc_val);
		ds_anrs();
		ds_anvl();
	}

	return(rc);
}

/* 
*/

/*
   =============================================================================
	sdxkey() -- score delete key processing
   =============================================================================
*/

void sdxkey(void)
{
	register int16_t col, grp, sect;
	register struct s_entry *ep, *rp;

	if (NOT astat)			/* only do when key goes down */
		return;

	if (clkrun)			/* ... and not while clock is running */
		return;

	if (scmctl NE -1)		/* ... and area 1 menu is down */
		return;
/* 
*/
	if (sdmctl EQ 4) {		/* section menu is up */

		if (((vtcrow EQ 19) OR (vtcrow EQ 20)) AND
		    (vtccol GE 24)) {

			if (NOT recsw)
				return;

			/* set up to delete a section marker */

			sect = ((vtccol - 24) >> 2) + ((vtcrow EQ 20) ? 10 : 0);
			col  = (vtccol - 24) & 3;

			switch (col) {

			case 0:		/* delete begin section */


				if (E_NULL NE (ep = seclist[curscor][sect])) {

					/* fix pointers */

					rp = ep->e_fwd;

					if (p_bak EQ ep)
						p_bak = rp;

					if (p_cur EQ ep)
						p_cur = rp;

					if (p_ctr EQ ep)
						p_ctr = rp;

					if (p_fwd EQ ep)
						p_fwd = rp;

					eh_rmv(ep, EH_SBGN);	/* delete */
					e_del(e_rmv(ep));
					seclist[curscor][sect] = E_NULL;
					sdmenu(-1);		/* take down menu */
					sc_refr(fc_val);	/* refresh screen */
				}

				break;
/* 
*/
			case 1:		/* section number */
			case 2:
				break;

			case 3:		/* delete end section */

				if (E_NULL NE
				   (ep = ehfind(EV_SEND, -1L, sect, -1))) {

					/* fix pointers */

					rp = ep->e_fwd;

					if (p_bak EQ ep)
						p_bak = rp;

					if (p_cur EQ ep)
						p_cur = rp;

					if (p_ctr EQ ep)
						p_ctr = rp;

					if (p_fwd EQ ep)
						p_fwd = rp;

					eh_rmv(ep, EH_SEND);	/* delete */
					e_del(e_rmv(ep));
					sdmenu(-1);		/* take down menu */
					sc_refr(fc_val);	/* refresh screen */
				}

				break;
			}

			return;

/* 
*/
		} else if ((vtcrow EQ 23) AND
			   (vtccol GE 28) AND (vtccol LE 62)) {

			/* group map entry */

			col = vtccol - 28;

			if (2 EQ (col % 3))
				return;

			grp = col / 3;
			grptmap[grp] = -1;
			dsgtme(grp);
			return;
		}
	}

	if (NOT recsw)	/* do only if recording */
		return;

	if ((cyval GE 14) AND (cyval LE 223)) {			/* notes */

		delnote();		/* delete a note */

	} else if ((cyval GE 224) AND (cyval LE 237)) {		/* new data */

		if (cp2time(cxval))
			delevts(-1, ctime);	/* delete all events at cursor */

/* 
*/

	} else if (stcrow EQ 17) {

		if ((stccol GE 11) AND (stccol LE 12))
			delevts(EV_ASGN, t_cur);		/* assignment */
		else if (stccol EQ 19)
			delevts(EV_TUNE, t_cur);		/* tuning */
		else if ((stccol GE 27) AND (stccol LE 29))
			delevts(EV_TMPO, t_cur);		/* tempo */
		else if ((stccol GE 36) AND (stccol LE 38))
			delevts(EV_INTP, t_cur);		/* interpolation */
		else if ((stccol GE 40) AND (stccol LE 43))
			delevts(EV_STOP, t_cur);		/* stop */
		else if ((stccol GE 45) AND (stccol LE 48))
			delevts(EV_NEXT, t_cur);		/* next */
		else if ((stccol GE 50) AND (stccol LE 55))
			delevts(EV_PNCH, t_cur);		/* punch in/out */

	} else if ((stcrow EQ 18) AND
		   (0 EQ ((stccol - 5) % 5))) {			/* group status */

		delevts(EV_GRP, t_cur);

	} else if ((stcrow EQ 18) AND
		    ((2 EQ ((stccol - 5) % 5)) OR
		     (3 EQ ((stccol - 5) % 5)))) {		/* instrument */

		delevts(EV_INST, t_cur);

	} else if (stcrow EQ 19) {				/* transposition */

		delevts(EV_TRNS, t_cur);

	} else if ((stcrow EQ 20) AND (stccol GE 6) AND
		   (0 EQ ((stccol - 6) % 5))) {			/* dynamics */

		delevts(EV_DYN, t_cur);

	} else if ((stcrow EQ 20) AND (stccol GE 6) AND
		   (2 EQ ((stccol - 6) % 5))) {			/* location */

		delevts(EV_LOCN, t_cur);

	} else if (stcrow EQ 23) {				/* analog */

		deladat();
/* 
*/
	} else if (stcrow EQ 24) {				/* score */

		if (stccol LE 4) {

			/* clear score */

			if (insmode)		/* cancel insert mode */
				icancel();

			sc_clr(curscor);	/* clear score itself */
			selscor(curscor);	/* refresh the display */

		} else if ((stccol GE 10) AND (stccol LE 25)) {

			/* clear score name */

			memset(scname[curscor], ' ', 16);
			dswin(13);
		}
	}
}

/* 
*/

/*
   =============================================================================
	sdmkey() -- score display menu key processor
   =============================================================================
*/

void sdmkey(void)
{
	if (astat) {

		if (insmode)
			icancel();
	}

	stdmkey();
}

/* 
*/

/*
   =============================================================================
	scfield() -- setup field routines for the score display
   =============================================================================
*/

void scfield(void)
{
	curset(&sc_flds);
}
