/*
 *  Copyright (C) 2017 The Contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  A copy of the GNU General Public License can be found in the file
 *  "gpl.txt" in the top directory of this repository.
 */

#include <all.h>

#define ver(...) _ver(tim_verbose, 0, __VA_ARGS__)
#define ver2(...) _ver(tim_verbose, 1, __VA_ARGS__)
#define ver3(...) _ver(tim_verbose, 2, __VA_ARGS__)

int32_t tim_verbose = 0;

void tim_init(void)
{
	ver("tim init");
}

void tim_quit(void)
{
	ver("tim quit");
}

void tim_exec(void)
{
	ver3("tim exec");
}

uint32_t tim_read(uint32_t off, int32_t sz)
{
	ver2("tim rd %u:%d", off, sz * 8);
	return 0;
}

void tim_write(uint32_t off, int32_t sz, uint32_t val)
{
	ver2("tim wr %u:%d 0x%0*x", off, sz * 8, sz * 2, val);
}
