/*
 *  Copyright (C) 2017 The Contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  A copy of the GNU General Public License can be found in the file
 *  "gpl-v3.txt" in the top directory of this repository.
 */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <unistd.h>

#include <xmmintrin.h>

#include <m68k.h>

#include <SDL2/SDL.h>

#define inf(...) SDL_LogInfo(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__);
#define err(...) SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__);

#define _ver(_v, _t, ...) { \
	if (_v > _t) { \
		SDL_LogVerbose(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__); \
	} \
}

#define fail(...) { \
	SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__); \
	exit(1); \
}

#define ARRAY_COUNT(_a) (int32_t)(sizeof (_a) / sizeof (_a)[0])

extern int32_t sdl_verbose;
extern int32_t cpu_verbose;
extern int32_t fpu_verbose;
extern int32_t vid_verbose;
extern int32_t tim_verbose;
extern int32_t lcd_verbose;
extern int32_t ser_verbose;
extern int32_t mid_verbose;
extern int32_t fdd_verbose;
extern int32_t snd_verbose;
extern int32_t led_verbose;
extern int32_t kbd_verbose;

extern void sdl_init(void);
extern void sdl_quit(void);

extern void cpu_loop(const char *bios);

extern void fpu_init(void);
extern void fpu_quit(void);
extern void fpu_exec(void);
extern uint32_t fpu_read(uint32_t off, int32_t sz);
extern void fpu_write(uint32_t off, int32_t sz, uint32_t val);

extern void vid_init(void);
extern void vid_quit(void);
extern void vid_exec(void);
extern uint32_t vid_read(uint32_t off, int32_t sz);
extern void vid_write(uint32_t off, int32_t sz, uint32_t val);

extern void tim_init(void);
extern void tim_quit(void);
extern void tim_exec(void);
extern uint32_t tim_read(uint32_t off, int32_t sz);
extern void tim_write(uint32_t off, int32_t sz, uint32_t val);

extern void lcd_init(void);
extern void lcd_quit(void);
extern void lcd_exec(void);
extern uint32_t lcd_read(uint32_t off, int32_t sz);
extern void lcd_write(uint32_t off, int32_t sz, uint32_t val);

extern void ser_init(void);
extern void ser_quit(void);
extern void ser_exec(void);
extern uint32_t ser_read(uint32_t off, int32_t sz);
extern void ser_write(uint32_t off, int32_t sz, uint32_t val);

extern void mid_init(void);
extern void mid_quit(void);
extern void mid_exec(void);
extern uint32_t mid_read(uint32_t off, int32_t sz);
extern void mid_write(uint32_t off, int32_t sz, uint32_t val);

extern void fdd_init(void);
extern void fdd_quit(void);
extern void fdd_exec(void);
extern uint32_t fdd_read(uint32_t off, int32_t sz);
extern void fdd_write(uint32_t off, int32_t sz, uint32_t val);

extern void snd_init(void);
extern void snd_quit(void);
extern void snd_exec(void);
extern uint32_t snd_read(uint32_t off, int32_t sz);
extern void snd_write(uint32_t off, int32_t sz, uint32_t val);

extern void led_init(void);
extern void led_quit(void);
extern void led_exec(void);
extern uint32_t led_read(uint32_t off, int32_t sz);
extern void led_write(uint32_t off, int32_t sz, uint32_t val);

extern void kbd_init(void);
extern void kbd_quit(void);
extern void kbd_exec(void);
extern uint32_t kbd_read(uint32_t off, int32_t sz);
extern void kbd_write(uint32_t off, int32_t sz, uint32_t val);
