#!/usr/bin/env python3

import sys
import re

def convert_line(line):
    if line == "*":
        return ""

    # |foo .equ *| -> |foo:|

    m = re.match(r"^([a-z0-9_]+)\t+.equ\t+\*(.*)$", line)

    if m != None:
        lab = m.group(1) + ":"
        com = m.group(2).strip()
        line = lab + "\t\t\t\t\t"[len(lab) // 8:] + com

    # |foo: dc.b '(...)'| -> |foo: dc.b "(...)"|

    m = re.match(r"((?:^[a-z0-9]+:)?\t+dc.b\t+)'([^']+)'(.*)$", line)

    if m != None:
        line = m.group(1) + "\"" + m.group(2) + "\"" + m.group(3)

    line = line.replace("*", "|")
    line = line.replace("$", "0x")
    line = line.replace(".equ", "=")
    return line

def convert(in_path, out_path):
    lines = []

    with open(in_path, "r") as f:
        for line in f:
            line = line.rstrip()
            line = convert_line(line)
            lines.append(line)

    with open(out_path, "w") as f:
        for line in lines:
            print(line, file = f)

if len(sys.argv) != 3:
    raise Exception("usage: asm.py in-path out-path")

convert(sys.argv[1], sys.argv[2])
