/*
   ============================================================================
	conwr.c -- write on the console
	Version 4 -- 1987-06-29 -- D.N. Lynx Crowe
   ============================================================================
*/

#define	_FS_DEF_		/* to avoid unnecessary externals */

#include "all.h"

/*
   ============================================================================
	_conwr(kind, buff, len) -- write 'len' bytes from 'buff' on the console
	using op 'kind' as the BIOS argument.
   ============================================================================
*/
int16_t _conwr(int16_t kind, int8_t *buff, int16_t len)
{
	register int16_t count;

	for (count = 0; count < len; ++count)
		BIOS(B_PUTC, kind, *buff++);

	return(count);
}

