/*
   =============================================================================
	fseek.c -- perform a seek on a stream file
	Version 4 -- 1987-10-28 -- D.N. Lynx Crowe
   =============================================================================
*/

#include "all.h"

extern	int32_t	lseek(int16_t fd, int32_t pos, int16_t how);

extern	int16_t flush_(FILE *ptr, int16_t data);

/*
   =============================================================================
	fseek(fp, pos, mode) -- position file 'fp' at 'pos' in mode 'mode'.
   =============================================================================
*/

int16_t fseek(FILE *fp, int32_t pos, int16_t mode)
{
	register int16_t i, lr;
	int32_t curpos;

	if (fp->_flags & _DIRTY) {

		if (flush_(fp, -1))
			return(EOF);

	} else {

		if (mode EQ 1 AND fp->_bp)
			pos -= (int32_t)fp->_bend - (int32_t)fp->_bp;
	}

	fp->_bp = fp->_bend = NULL;
	fp->_flags &= ~_EOF;

	lr = lseek(fp->_unit, pos, mode);

	if (((struct fcb *)chantab[fp->_unit].c_arg)->modefl & FC_EOF)
		fp->_flags |= _EOF;

	if (lr < 0)
		return(EOF);

	return(0);
}


