#!/usr/bin/env python3

from sys import stdout

with open("misc/c-files.txt", "r") as f:
    for path in f:
        path = path.rstrip()

        if path == "ram/wdfield.c": # breaks pycparser
            continue

        if path[-2:] != ".c":
            continue

        stdout.write("fixing {}                    \r".format(path))
        stdout.flush()

        with open(path, "r") as f:
            lines = f.read().split("\n")

        beg = None
        end = None
        idx = 0

        for line in lines:
            if len(line) >= 8 and line[:8] == "#include":
                if beg is None:
                    beg = idx

                end = idx

            elif len(line) != 0 and beg is not None:
                break

            idx += 1

        if beg is not None:
            out = lines[0 : beg] + ["#include \"all.h\""] + lines[end + 1:] + [""]

            with open(path, "w") as f:
                f.write("\n".join(out))

    print("")
