/*
   =============================================================================
	vtext.c -- output a text string to the VSDD in 1 byte / character mode
	Version 3 -- 1987-06-02 -- D.N. Lynx Crowe

	Assumes VSDD is pointing at bank 0.
   =============================================================================
*/

#include "all.h"

static int16_t	msk[] = { 0xFF00, 0x00FF };

void vtext(uint16_t *obj, uint16_t nc, uint16_t row, uint16_t col, int8_t *ip)
{
	register uint16_t *op;

	while (*ip) {

		op = obj + ((nc >> 1) * row) + (col >> 1);

		*op = (*op & (uint16_t)msk[col & 1]) |
		      ((*ip++ & 0x00FF) << ((col & 1) ? 8 : 0));

		col++;
	}
}
