#pragma once

#include "score.h"
#include "setjmp.h"
#include "slice.h"
#include "stdint.h"
#include "vsdd.h"

/*
   =============================================================================
	proto.c -- global variables
   =============================================================================
*/

extern	int8_t		*M1IoRec;
extern	int8_t		*M2IoRec;
extern	int8_t		*S1IoRec;
extern	int8_t		*S2IoRec;
extern	int8_t		VerDate[];
extern	int8_t		ac_code;
extern	int16_t		*crshpc;
extern	int32_t		crshrg[16];
extern	int16_t		*crshsp;
extern	uint16_t	crshsr;
extern	int16_t		crshst[16];
extern	int16_t		*crshus;
extern	int8_t		crshvc[4];
extern	int8_t		edata;
extern	int8_t		end;
extern	int16_t		errno;
extern	int8_t		etext;
extern	void		(*foot1)(int16_t stat);
extern	void		(*foot2)(int16_t stat);
extern	int16_t		fp_resv[];
extern	int32_t		p_dlen;
extern	void		(*pulse1)(void);
extern	void		(*pulse2)(void);
extern	int16_t		timers[8];
extern	int32_t		uldivr;
extern	uint16_t	vi_sadr;
extern	uint16_t	vi_scrl;
extern	int16_t		wzcrsh;

/*
   =============================================================================
	proto.c -- global functions
   =============================================================================
*/

extern	void		GLCplot(uint16_t x, uint16_t y, uint16_t val);
extern	void		Lo_RAM(void);
extern	void		VIint(void);
extern	void		_ptcl12(uint16_t *fat, uint16_t cl, uint16_t val);
extern	void		clrvce(int16_t vce);
extern	void		execins(int16_t vce, int16_t ins, int16_t tag);
extern	void		execkey(int16_t trg, int16_t pch, int16_t vce, int16_t tag);
extern	void		fpuclr(void);
extern	void		fpuint(void);
extern	uint16_t	fromfpu(uint16_t fputime);
extern	void		halt(void);
extern	void		hdvini(void);
extern	void		jumpto(void *addr);
extern	void		longjmp(struct JMP_BUF *env, int16_t val);
extern	void		objclr(uint16_t obj);
extern	void		objoff(uint16_t obj, uint16_t line, uint16_t num);
extern	void		objon(uint16_t obj, uint16_t line, uint16_t num);
extern	void		panic(void);
extern	void		procpfl(uint16_t trig);
extern	int32_t		rand24(void);
extern	void		rjumpto(void *addr);
extern	void		se_disp(struct s_entry *ep, int16_t sd, struct gdsel *gdstb[], int16_t cf);
extern	struct	s_entry	*se_exec(struct s_entry *ep, int16_t sd);
extern	uint16_t	setipl(uint16_t arg);
extern	int16_t		setjmp(struct JMP_BUF *env);
extern	void		setsio(void);
extern	uint16_t	setsr(uint16_t sr);
extern	void		sjumpto(void *addr, void *stack);
extern	void		sreset(void);
extern	uint16_t	tofpu(uint16_t time);
extern	int32_t		trap13(int16_t fun, ...);
extern	int32_t		trap14(int16_t fun, ...);
extern	void		trap15(void);
extern	void		tsetup(void);
extern	void		tsplot4(int16_t *obase, int16_t nw, int16_t fg, int16_t row, int16_t col, int8_t *str, int16_t pitch);
extern	int32_t		uldiv(int32_t divid, int32_t divis);
extern	void		vbank(uint16_t b);
extern	void		vclrav(uint16_t *adr, uint16_t row, uint16_t col, uint16_t atr, uint16_t len);
extern	void		vcputs(int16_t *obase, int16_t nw, int16_t fg, int16_t bg, int16_t row, int16_t col, int8_t *str);
extern	void		vcputsv(int16_t *obase, int16_t nw, int16_t fg, int16_t bg, int16_t row, int16_t col, int8_t *str, int16_t pitch);
extern	void		vfwait(void);
extern	void		vputa(uint16_t *sbase, uint16_t row, uint16_t col, uint16_t attrib);
extern	void		vputc(uint16_t *sbase, uint16_t row, uint16_t col, uint16_t c, uint16_t attrib);
extern	void		vputcv(uint16_t *adr, uint16_t row, uint16_t col, uint8_t chr, uint16_t atr, uint16_t cols);
extern	void		vputp(struct octent *octad, int16_t xloc, int16_t yloc, int16_t val);
extern	void		vsetav(uint16_t *adr, uint16_t row, uint16_t col, uint16_t atr, uint16_t len);
extern	void		vsetcv(uint16_t *adr, uint16_t row, uint16_t col, uint16_t cfb, uint16_t len);
extern	void		vsplot4(uint16_t *obase, uint16_t nw, uint16_t fg, uint16_t row, uint16_t col, int8_t *str, uint16_t pitch, uint16_t ht, int16_t cgtab[][256]);
extern	void		vvputsv(uint16_t *obase, uint16_t nw, uint16_t fg, uint16_t bg, uint16_t row, uint16_t col, int8_t *str, uint16_t pitch, uint16_t ht, int16_t cgtab[][256]);
extern	void		vwputp(struct octent *octad, int16_t xloc, int16_t yloc, int16_t val);
extern	void		vwputs(int16_t *obase, int16_t nw, int16_t fg, int16_t bg, int16_t row, int16_t col, int8_t *str);
extern	void		xtrap15(void);
