/*
   ============================================================================
	wordq.h -- header for word queue functions
	Version 1 -- 1988-11-02 -- D.N. Lynx Crowe
   ============================================================================
*/

struct	wordq {

	uint16_t	qsize;		/* maximum queue length */
	uint16_t	qlen;		/* current queue length */
	uint16_t	qin;		/* in pointer */
	uint16_t 	qout;		/* out pointer */
	uint16_t	qhi;		/* high water mark */
	uint16_t	qlo;		/* low water mark */
	uint16_t	*qbuf;		/* base of queue */
};

#ifndef	WORDQHDR
extern	int16_t	putwq(struct wordq *qp, uint16_t c);
extern	int16_t	getwq(struct wordq *qp, uint16_t *p);
extern	uint16_t	setwq(struct wordq *qp, uint16_t *qadr, uint16_t qsiz, uint16_t hi, uint16_t lo);
#endif

