/*
   =============================================================================
	 knmtab.h -- MIDAS-VII Harmonic coefficient tables
	Calculated 1988-09-20 -- 11:25:44
   =============================================================================
*/

/*
   =============================================================================
	Calculated by htgen.c -- Version 2 -- 1988-09-20
	for MIDAS-VII using:

		Full scale range = 1023

		Width of table   = 256
		Center of table  = 127
		Scan width (N)   = 115
		Points scanned   = 12 thru 242
   =============================================================================
*/

int16_t	knmtab[32][256] = {

/* 
*/

/* Harmonic table # 1 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1013,-1004, -995,	/*  15 */
	  -986, -978, -969, -960, -951, -942, -933, -924, -915, -906, -897, -889, -880, -871, -862, -853,	/*  31 */
	  -844, -835, -826, -817, -808, -800, -791, -782, -773, -764, -755, -746, -737, -728, -720, -711,	/*  47 */
	  -702, -693, -684, -675, -666, -657, -648, -639, -631, -622, -613, -604, -595, -586, -577, -568,	/*  63 */
	  -559, -551, -542, -533, -524, -515, -506, -497, -488, -479, -470, -462, -453, -444, -435, -426,	/*  79 */
	  -417, -408, -399, -390, -382, -373, -364, -355, -346, -337, -328, -319, -310, -301, -293, -284,	/*  95 */
	  -275, -266, -257, -248, -239, -230, -221, -212, -204, -195, -186, -177, -168, -159, -150, -141,	/* 111 */
	  -132, -124, -115, -106,  -97,  -88,  -79,  -70,  -61,  -52,  -43,  -35,  -26,  -17,   -8,    0,	/* 127 */
	     9,   18,   27,   36,   44,   53,   62,   71,   80,   89,   98,  107,  116,  125,  133,  142,	/* 143 */
	   151,  160,  169,  178,  187,  196,  205,  214,  222,  231,  240,  249,  258,  267,  276,  285,	/* 159 */
	   294,  302,  311,  320,  329,  338,  347,  356,  365,  374,  383,  391,  400,  409,  418,  427,	/* 175 */
	   436,  445,  454,  463,  471,  480,  489,  498,  507,  516,  525,  534,  543,  552,  560,  569,	/* 191 */
	   578,  587,  596,  605,  614,  623,  632,  640,  649,  658,  667,  676,  685,  694,  703,  712,	/* 207 */
	   721,  729,  738,  747,  756,  765,  774,  783,  792,  801,  810,  818,  827,  836,  845,  854,	/* 223 */
	   863,  872,  881,  890,  898,  907,  916,  925,  934,  943,  952,  961,  970,  979,  987,  996,	/* 239 */
	  1005, 1014, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 2 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,  988,  952,  918,	/*  15 */
	   883,  849,  815,  781,  748,  715,  683,  650,  618,  587,  555,  524,  493,  463,  433,  403,	/*  31 */
	   373,  344,  315,  286,  258,  230,  202,  175,  148,  121,   95,   69,   43,   17,   -7,  -32,	/*  47 */
	   -57,  -81, -105, -128, -152, -175, -198, -220, -242, -264, -285, -307, -328, -348, -368, -388,	/*  63 */
	  -408, -427, -446, -465, -483, -502, -519, -537, -554, -571, -587, -604, -620, -635, -651, -666,	/*  79 */
	  -680, -695, -709, -723, -736, -749, -762, -774, -787, -799, -810, -822, -832, -843, -854, -864,	/*  95 */
	  -873, -883, -892, -901, -909, -917, -925, -933, -940, -947, -954, -960, -966, -972, -977, -982,	/* 111 */
	  -987, -992, -996,-1000,-1003,-1007,-1009,-1012,-1014,-1016,-1018,-1020,-1021,-1021,-1022,-1022,	/* 127 */
	 -1022,-1021,-1021,-1020,-1018,-1016,-1014,-1012,-1009,-1007,-1003,-1000, -996, -992, -987, -982,	/* 143 */
	  -977, -972, -966, -960, -954, -947, -940, -933, -925, -917, -909, -901, -892, -883, -873, -864,	/* 159 */
	  -854, -843, -832, -821, -810, -799, -787, -774, -762, -749, -736, -722, -709, -695, -680, -666,	/* 175 */
	  -651, -635, -620, -604, -587, -571, -554, -537, -519, -502, -483, -465, -446, -427, -408, -388,	/* 191 */
	  -368, -348, -328, -307, -285, -264, -242, -220, -198, -175, -152, -128, -105,  -81,  -56,  -32,	/* 207 */
	    -7,   17,   43,   69,   95,  121,  148,  175,  202,  230,  258,  286,  315,  344,  373,  403,	/* 223 */
	   433,  463,  493,  524,  555,  587,  618,  650,  683,  715,  748,  782,  815,  849,  883,  918,	/* 239 */
	   952,  988, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 3 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, -943, -866, -790,	/*  15 */
	  -716, -645, -574, -506, -440, -375, -311, -250, -190, -132,  -76,  -21,   31,   83,  133,  182,	/*  31 */
	   228,  274,  318,  360,  401,  440,  478,  515,  550,  584,  616,  647,  677,  705,  732,  757,	/*  47 */
	   782,  805,  827,  847,  866,  885,  901,  917,  932,  945,  958,  969,  979,  988,  996, 1003,	/*  63 */
	  1009, 1013, 1017, 1020, 1022, 1023, 1023, 1022, 1020, 1017, 1014, 1009, 1004,  998,  991,  983,	/*  79 */
	   975,  966,  956,  945,  934,  922,  909,  895,  881,  866,  851,  835,  819,  802,  784,  766,	/*  95 */
	   747,  728,  708,  688,  668,  647,  625,  603,  581,  558,  535,  512,  489,  465,  440,  416,	/* 111 */
	   391,  366,  341,  316,  290,  264,  238,  212,  186,  160,  133,  107,   80,   53,   27,    0,	/* 127 */
	   -26,  -52,  -79, -106, -132, -159, -185, -211, -237, -263, -289, -315, -340, -365, -390, -415,	/* 143 */
	  -439, -464, -488, -511, -535, -557, -580, -602, -624, -646, -667, -687, -707, -727, -746, -765,	/* 159 */
	  -783, -801, -818, -834, -850, -865, -880, -894, -908, -921, -933, -944, -955, -965, -974, -982,	/* 175 */
	  -990, -997,-1003,-1008,-1013,-1016,-1019,-1021,-1022,-1022,-1021,-1019,-1016,-1012,-1008,-1002,	/* 191 */
	  -995, -987, -978, -968, -957, -944, -931, -916, -900, -884, -865, -846, -826, -804, -781, -756,	/* 207 */
	  -731, -704, -676, -646, -615, -583, -549, -514, -477, -439, -400, -359, -317, -273, -227, -181,	/* 223 */
	  -132,  -82,  -30,   22,   77,  133,  191,  251,  313,  376,  441,  507,  575,  646,  717,  791,	/* 239 */
	   867,  944, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 4 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,  884,  751,  623,	/*  15 */
	   502,  386,  276,  171,   71,  -22, -111, -195, -275, -349, -419, -485, -546, -603, -656, -705,	/*  31 */
	  -750, -791, -828, -862, -892, -918, -942, -962, -979, -993,-1004,-1013,-1018,-1021,-1022,-1020,	/*  47 */
	 -1016,-1009,-1000, -989, -976, -962, -945, -926, -906, -885, -862, -837, -811, -784, -755, -726,	/*  63 */
	  -695, -663, -631, -597, -563, -528, -493, -456, -420, -383, -345, -307, -269, -231, -192, -153,	/*  79 */
	  -115,  -76,  -37,    0,   39,   77,  115,  153,  190,  227,  264,  300,  335,  370,  405,  438,	/*  95 */
	   472,  504,  536,  567,  597,  626,  655,  682,  709,  734,  759,  783,  806,  827,  848,  868,	/* 111 */
	   886,  904,  920,  935,  949,  962,  973,  984,  993, 1001, 1008, 1013, 1017, 1021, 1022, 1023,	/* 127 */
	  1022, 1021, 1017, 1013, 1008, 1001,  993,  984,  973,  962,  949,  935,  920,  903,  886,  868,	/* 143 */
	   848,  827,  806,  783,  759,  734,  709,  682,  654,  626,  597,  567,  536,  504,  471,  438,	/* 159 */
	   405,  370,  335,  300,  263,  227,  190,  153,  115,   77,   39,    0,  -37,  -76, -115, -153,	/* 175 */
	  -192, -231, -269, -307, -345, -383, -420, -456, -493, -528, -563, -597, -631, -663, -695, -726,	/* 191 */
	  -755, -784, -811, -837, -862, -885, -906, -927, -945, -962, -976, -989,-1000,-1009,-1016,-1020,	/* 207 */
	 -1022,-1021,-1018,-1013,-1004, -993, -979, -962, -942, -918, -892, -862, -828, -791, -750, -705,	/* 223 */
	  -656, -603, -546, -485, -419, -349, -275, -195, -111,  -22,   72,  171,  276,  386,  502,  623,	/* 239 */
	   751,  884, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 5 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, -807, -607, -422,	/*  15 */
	  -250,  -92,   53,  186,  307,  418,  517,  606,  685,  755,  815,  867,  911,  947,  975,  997,	/*  31 */
	  1012, 1020, 1023, 1020, 1012,  999,  981,  959,  933,  903,  870,  834,  795,  753,  709,  663,	/*  47 */
	   615,  565,  514,  462,  408,  354,  299,  244,  189,  133,   78,   22,  -32,  -86, -140, -193,	/*  63 */
	  -245, -296, -346, -395, -442, -488, -533, -575, -617, -656, -694, -730, -764, -796, -826, -854,	/*  79 */
	  -879, -903, -925, -944, -962, -977, -990,-1000,-1009,-1015,-1020,-1022,-1022,-1019,-1015,-1009,	/*  95 */
	 -1000, -990, -977, -963, -947, -929, -909, -887, -864, -838, -812, -784, -754, -723, -690, -656,	/* 111 */
	  -621, -585, -548, -510, -470, -430, -390, -348, -306, -263, -220, -176, -132,  -88,  -43,    0,	/* 127 */
	    45,   89,  133,  177,  221,  264,  307,  349,  391,  431,  472,  511,  549,  586,  622,  657,	/* 143 */
	   691,  724,  755,  785,  813,  839,  865,  888,  910,  930,  948,  964,  978,  991, 1001, 1010,	/* 159 */
	  1016, 1020, 1023, 1023, 1021, 1016, 1010, 1001,  991,  978,  963,  945,  926,  904,  880,  855,	/* 175 */
	   827,  797,  765,  731,  695,  657,  618,  576,  534,  489,  443,  396,  347,  297,  246,  194,	/* 191 */
	   141,   87,   33,  -21,  -77, -132, -188, -243, -298, -353, -407, -461, -513, -564, -614, -662,	/* 207 */
	  -708, -752, -794, -833, -869, -902, -932, -958, -980, -998,-1011,-1019,-1022,-1019,-1011, -996,	/* 223 */
	  -974, -946, -910, -866, -814, -754, -684, -605, -516, -417, -306, -185,  -52,   93,  251,  423,	/* 239 */
	   608,  808, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 6 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,  719,  445,  200,	/*  15 */
	   -16, -207, -375, -519, -643, -746, -831, -899, -951, -987,-1011,-1021,-1020,-1009, -987, -958,	/*  31 */
	  -920, -875, -825, -768, -708, -643, -575, -504, -430, -356, -280, -204, -127,  -51,   24,   99,	/*  47 */
	   172,  243,  313,  380,  445,  507,  566,  622,  675,  724,  770,  812,  850,  885,  916,  942,	/*  63 */
	   965,  985, 1000, 1011, 1019, 1023, 1023, 1019, 1012, 1001,  987,  969,  948,  924,  897,  868,	/*  79 */
	   835,  800,  763,  723,  681,  637,  591,  544,  495,  445,  393,  341,  287,  233,  179,  124,	/*  95 */
	    68,   13,  -41,  -96, -151, -205, -258, -311, -362, -412, -461, -509, -555, -600, -643, -684,	/* 111 */
	  -723, -760, -795, -827, -858, -886, -911, -934, -954, -972, -987,-1000,-1010,-1016,-1021,-1022,	/* 127 */
	 -1021,-1016,-1009,-1000, -987, -972, -954, -934, -911, -886, -858, -827, -795, -760, -723, -684,	/* 143 */
	  -643, -600, -555, -509, -461, -412, -362, -310, -258, -205, -151,  -96,  -41,   13,   68,  124,	/* 159 */
	   179,  233,  287,  341,  393,  445,  495,  544,  591,  637,  681,  723,  763,  800,  835,  868,	/* 175 */
	   897,  924,  948,  969,  987, 1001, 1012, 1019, 1023, 1023, 1019, 1011, 1000,  985,  965,  942,	/* 191 */
	   915,  885,  850,  812,  769,  724,  674,  622,  566,  507,  445,  380,  313,  243,  172,   98,	/* 207 */
	    24,  -51, -127, -204, -280, -356, -431, -504, -575, -643, -708, -769, -825, -875, -920, -958,	/* 223 */
	  -987,-1009,-1020,-1021,-1010, -987, -950, -899, -831, -746, -643, -519, -375, -207,  -16,  201,	/* 239 */
	   445,  719, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 7 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, -616, -265,   32,	/*  15 */
	   284,  491,  659,  791,  890,  960, 1002, 1021, 1019,  999,  961,  910,  847,  774,  692,  603,	/*  31 */
	   510,  412,  312,  211,  110,    9,  -89, -186, -279, -369, -454, -534, -609, -679, -742, -799,	/*  47 */
	  -850, -894, -932, -963, -987,-1005,-1017,-1022,-1020,-1013,-1000, -981, -957, -927, -893, -854,	/*  63 */
	  -811, -764, -713, -658, -601, -541, -479, -415, -349, -282, -213, -145,  -75,   -6,   62,  130,	/*  79 */
	   198,  264,  329,  392,  453,  512,  569,  623,  674,  723,  768,  809,  848,  883,  914,  941,	/*  95 */
	   965,  984, 1000, 1011, 1019, 1023, 1022, 1018, 1010,  998,  982,  962,  939,  912,  881,  848,	/* 111 */
	   811,  771,  729,  684,  636,  586,  533,  479,  423,  365,  307,  247,  186,  124,   62,    0,	/* 127 */
	   -61, -123, -185, -246, -306, -365, -422, -478, -532, -585, -635, -683, -728, -770, -810, -847,	/* 143 */
	  -881, -911, -938, -961, -981, -997,-1009,-1017,-1021,-1022,-1018,-1010, -999, -983, -963, -940,	/* 159 */
	  -913, -882, -847, -808, -767, -722, -673, -622, -568, -511, -452, -391, -328, -263, -197, -129,	/* 175 */
	   -61,    7,   76,  146,  215,  283,  350,  416,  480,  542,  602,  660,  714,  765,  812,  855,	/* 191 */
	   894,  928,  958,  982, 1001, 1014, 1021, 1023, 1018, 1006,  988,  964,  933,  895,  851,  800,	/* 207 */
	   743,  679,  610,  535,  455,  370,  280,  187,   90,   -8, -109, -210, -311, -411, -509, -603,	/* 223 */
	  -691, -773, -846, -909, -961, -998,-1018,-1020,-1001, -959, -889, -790, -658, -490, -283,  -31,	/* 239 */
	   266,  617, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 8 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,  504,   78, -263,	/*  15 */
	  -530, -731, -873, -965,-1012,-1021, -997, -947, -873, -782, -676, -560, -436, -308, -178,  -48,	/*  31 */
	    79,  202,  320,  432,  535,  630,  715,  790,  855,  910,  953,  986, 1009, 1021, 1023, 1015,	/*  47 */
	   997,  971,  936,  894,  844,  788,  726,  659,  587,  511,  432,  350,  266,  181,   95,    9,	/*  63 */
	   -75, -159, -242, -322, -400, -475, -546, -613, -676, -734, -788, -836, -880, -917, -949, -975,	/*  79 */
	  -996,-1010,-1019,-1022,-1019,-1010, -996, -976, -951, -921, -886, -846, -802, -754, -702, -646,	/*  95 */
	  -587, -525, -461, -394, -326, -256, -184, -112,  -40,   32,  104,  176,  246,  316,  383,  449,	/* 111 */
	   512,  573,  631,  686,  737,  785,  829,  868,  904,  935,  962,  984, 1001, 1013, 1021, 1023,	/* 127 */
	  1021, 1013, 1001,  984,  962,  935,  904,  868,  829,  785,  737,  686,  631,  573,  512,  449,	/* 143 */
	   383,  315,  246,  175,  104,   32,  -40, -113, -185, -256, -326, -394, -461, -526, -587, -646,	/* 159 */
	  -702, -754, -802, -847, -886, -921, -951, -976, -996,-1010,-1019,-1022,-1019,-1010, -996, -975,	/* 175 */
	  -949, -917, -879, -836, -788, -734, -676, -613, -546, -474, -400, -322, -242, -159,  -75,    9,	/* 191 */
	    95,  181,  266,  350,  432,  511,  587,  659,  726,  788,  845,  894,  937,  971,  997, 1015,	/* 207 */
	  1023, 1021, 1009,  986,  953,  910,  855,  790,  715,  630,  535,  432,  320,  202,   79,  -48,	/* 223 */
	  -178, -308, -436, -560, -676, -782, -873, -947, -998,-1021,-1012, -965, -873, -731, -530, -263,	/* 239 */
	    78,  504, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 9 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, -381,  113,  481,	/*  15 */
	   741,  908,  998, 1023,  995,  924,  821,  693,  547,  390,  228,   65,  -93, -246, -389, -521,	/*  31 */
	  -639, -742, -830, -901, -956, -994,-1016,-1022,-1013, -990, -953, -905, -845, -775, -696, -610,	/*  47 */
	  -518, -421, -320, -217, -112,   -7,   96,  198,  297,  392,  483,  568,  648,  721,  787,  845,	/*  63 */
	   895,  937,  971,  997, 1014, 1022, 1022, 1014,  997,  973,  942,  903,  857,  805,  748,  685,	/*  79 */
	   617,  545,  469,  391,  309,  226,  142,   57,  -27, -112, -196, -278, -358, -435, -509, -580,	/*  95 */
	  -646, -708, -766, -818, -865, -906, -941, -970, -992,-1009,-1019,-1022,-1019,-1010, -994, -972,	/* 111 */
	  -944, -910, -870, -826, -776, -721, -662, -599, -532, -462, -389, -314, -237, -158,  -79,    0,	/* 127 */
	    80,  160,  238,  315,  390,  463,  533,  600,  663,  722,  777,  827,  872,  911,  945,  973,	/* 143 */
	   995, 1011, 1020, 1023, 1020, 1010,  993,  971,  942,  907,  866,  819,  767,  709,  647,  581,	/* 159 */
	   510,  436,  359,  279,  197,  113,   28,  -56, -141, -226, -309, -390, -469, -544, -616, -684,	/* 175 */
	  -747, -805, -856, -902, -941, -972, -996,-1013,-1021,-1021,-1013, -996, -970, -936, -894, -844,	/* 191 */
	  -785, -720, -647, -567, -482, -391, -296, -197,  -95,    8,  113,  218,  321,  422,  519,  612,	/* 207 */
	   698,  776,  846,  906,  955,  991, 1014, 1023, 1017,  995,  957,  902,  831,  743,  640,  522,	/* 223 */
	   390,  247,   94,  -65, -227, -390, -546, -692, -820, -923, -994,-1022, -997, -907, -740, -480,	/* 239 */
	  -111,  382, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 10 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,  254, -298, -672,	/*  15 */
	  -899,-1005,-1017, -954, -837, -681, -499, -304, -104,   91,  276,  447,  599,  730,  837,  920,	/*  31 */
	   978, 1012, 1023, 1011,  979,  927,  859,  775,  679,  572,  458,  337,  212,   86,  -39, -163,	/*  47 */
	  -283, -398, -505, -605, -696, -777, -847, -905, -952, -987,-1010,-1021,-1020,-1007, -983, -949,	/*  63 */
	  -904, -849, -787, -716, -638, -554, -465, -372, -276, -178,  -78,   21,  120,  218,  313,  405,	/*  79 */
	   492,  575,  653,  724,  789,  846,  896,  938,  972,  997, 1014, 1022, 1022, 1013,  996,  970,	/*  95 */
	   937,  897,  849,  794,  733,  667,  595,  518,  438,  355,  268,  180,   91,    1,  -88, -177,	/* 111 */
	  -265, -350, -433, -512, -587, -658, -724, -784, -838, -886, -927, -961, -987,-1007,-1018,-1022,	/* 127 */
	 -1018,-1007, -987, -961, -927, -886, -838, -784, -724, -658, -587, -512, -433, -350, -265, -177,	/* 143 */
	   -88,    1,   91,  180,  269,  355,  438,  519,  595,  667,  733,  794,  849,  897,  937,  971,	/* 159 */
	   996, 1013, 1022, 1022, 1014,  997,  972,  938,  896,  846,  789,  724,  653,  575,  492,  405,	/* 175 */
	   313,  218,  120,   21,  -78, -178, -276, -372, -466, -554, -638, -716, -787, -850, -904, -949,	/* 191 */
	  -983,-1007,-1020,-1021,-1010, -987, -952, -905, -847, -777, -696, -605, -505, -397, -283, -163,	/* 207 */
	   -39,   86,  212,  337,  458,  572,  679,  775,  859,  927,  979, 1011, 1023, 1012,  978,  920,	/* 223 */
	   837,  730,  599,  447,  276,   90, -105, -304, -500, -681, -837, -954,-1017,-1005, -899, -672,	/* 239 */
	  -298,  254, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 11 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, -120,  476,  831,	/*  15 */
	   996, 1016,  931,  772,  565,  333,   93, -140, -357, -550, -713, -842, -937, -996,-1021,-1013,	/*  31 */
	  -976, -911, -823, -715, -591, -455, -311, -162,  -12,  135,  278,  414,  539,  653,  754,  839,	/*  47 */
	   909,  963,  999, 1019, 1022, 1009,  981,  937,  880,  811,  730,  640,  542,  436,  326,  212,	/*  63 */
	    96,  -19, -135, -248, -357, -461, -559, -649, -731, -804, -868, -921, -963, -994,-1013,-1022,	/*  79 */
	 -1019,-1004, -979, -944, -898, -843, -780, -708, -630, -545, -455, -360, -262, -162,  -60,   41,	/*  95 */
	   142,  242,  339,  432,  521,  605,  683,  754,  818,  874,  922,  960,  990, 1010, 1021, 1022,	/* 111 */
	  1014,  996,  970,  934,  889,  837,  776,  709,  635,  556,  471,  382,  289,  194,   98,    0,	/* 127 */
	   -97, -194, -289, -381, -470, -555, -634, -708, -776, -836, -888, -933, -969, -995,-1013,-1021,	/* 143 */
	 -1020,-1009, -989, -959, -920, -873, -817, -753, -682, -604, -520, -431, -338, -241, -141,  -40,	/* 159 */
	    61,  163,  263,  361,  456,  546,  631,  709,  781,  844,  899,  945,  980, 1005, 1020, 1023,	/* 175 */
	  1014,  995,  964,  922,  869,  805,  732,  650,  559,  462,  358,  248,  136,   20,  -95, -211,	/* 191 */
	  -325, -436, -541, -639, -730, -810, -879, -936, -980,-1008,-1021,-1018, -998, -962, -908, -838,	/* 207 */
	  -753, -652, -538, -413, -277, -134,   13,  163,  312,  457,  592,  716,  824,  912,  977, 1014,	/* 223 */
	  1022,  997,  938,  843,  714,  551,  358,  141,  -92, -332, -564, -771, -930,-1015, -995, -829,	/* 239 */
	  -475,  122, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 12 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,  -12, -635, -943,	/*  15 */
	 -1021, -937, -746, -493, -212,   68,  331,  560,  747,  887,  977, 1019, 1015,  969,  887,  773,	/*  31 */
	   635,  478,  310,  134,  -40, -212, -374, -524, -658, -773, -868, -940, -990,-1017,-1021,-1003,	/*  47 */
	  -964, -906, -831, -740, -635, -520, -396, -266, -133,    1,  135,  265,  390,  507,  616,  713,	/*  63 */
	   799,  872,  932,  976, 1006, 1021, 1021, 1006,  978,  935,  880,  813,  735,  647,  552,  449,	/*  79 */
	   341,  229,  114,    0, -115, -228, -338, -444, -543, -635, -720, -795, -861, -916, -960, -992,	/*  95 */
	 -1013,-1022,-1019,-1004, -977, -939, -891, -832, -764, -688, -604, -513, -417, -316, -212, -105,	/* 111 */
	     1,  109,  215,  318,  418,  514,  603,  686,  762,  829,  887,  935,  973, 1001, 1017, 1023,	/* 127 */
	  1017, 1001,  973,  935,  887,  829,  762,  686,  603,  514,  418,  318,  215,  108,    1, -106,	/* 143 */
	  -212, -316, -417, -513, -604, -688, -765, -832, -891, -939, -977,-1004,-1019,-1022,-1013, -992,	/* 159 */
	  -960, -916, -861, -795, -720, -635, -543, -443, -338, -228, -115,    0,  115,  229,  341,  449,	/* 175 */
	   552,  647,  735,  813,  880,  935,  978, 1006, 1021, 1021, 1006,  976,  931,  872,  799,  713,	/* 191 */
	   615,  507,  390,  265,  135,    1, -133, -266, -396, -520, -635, -740, -831, -906, -964,-1003,	/* 207 */
	 -1021,-1017, -990, -940, -868, -773, -658, -524, -374, -212,  -40,  135,  310,  479,  635,  773,	/* 223 */
	   887,  970, 1015, 1019,  977,  887,  747,  560,  330,   68, -212, -493, -746, -937,-1021, -943,	/* 239 */
	  -635,  -12, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 13 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  148,  774, 1009,	/*  15 */
	   978,  778,  485,  156, -167, -458, -696, -871, -979,-1021,-1002, -928, -809, -654, -473, -276,	/*  31 */
	   -72,  130,  323,  501,  658,  789,  893,  967, 1010, 1023, 1006,  961,  891,  798,  686,  557,	/*  47 */
	   417,  268,  114,  -39, -191, -338, -475, -602, -714, -811, -891, -953, -995,-1018,-1021,-1005,	/*  63 */
	  -971, -919, -852, -769, -674, -567, -452, -329, -202,  -72,   58,  187,  312,  432,  544,  648,	/*  79 */
	   741,  822,  891,  946,  986, 1012, 1023, 1018, 1000,  966,  919,  859,  788,  705,  612,  512,	/*  95 */
	   405,  292,  175,   57,  -61, -179, -294, -405, -511, -609, -700, -780, -851, -910, -957, -992,	/* 111 */
	 -1013,-1022,-1017, -999, -968, -925, -870, -803, -727, -641, -547, -446, -339, -228, -114,    0,	/* 127 */
	   116,  229,  340,  447,  548,  642,  728,  805,  871,  926,  969, 1000, 1018, 1023, 1014,  993,	/* 143 */
	   958,  911,  852,  781,  700,  610,  512,  406,  295,  180,   62,  -56, -175, -291, -404, -511,	/* 159 */
	  -612, -704, -787, -859, -918, -965, -999,-1017,-1022,-1011, -985, -945, -890, -821, -740, -647,	/* 175 */
	  -543, -431, -311, -186,  -57,   73,  203,  330,  453,  568,  675,  770,  853,  920,  972, 1006,	/* 191 */
	  1022, 1019,  996,  953,  892,  812,  715,  603,  476,  339,  192,   40, -114, -267, -416, -557,	/* 207 */
	  -685, -797, -890, -960,-1005,-1022,-1009, -966, -892, -788, -657, -500, -322, -129,   73,  277,	/* 223 */
	   474,  655,  810,  929, 1003, 1022,  980,  872,  697,  459,  168, -155, -485, -778, -977,-1008,	/* 239 */
	  -772, -147, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 14 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -279, -883,-1020,	/*  15 */
	  -865, -550, -172,  201,  527,  778,  942, 1017, 1008,  926,  784,  597,  380,  147,  -86, -310,	/*  31 */
	  -514, -690, -831, -935, -999,-1022,-1006, -954, -869, -755, -617, -462, -294, -119,   56,  228,	/*  47 */
	   392,  544,  678,  794,  887,  957, 1002, 1022, 1017,  988,  936,  863,  771,  662,  540,  406,	/*  63 */
	   266,  120,  -26, -172, -313, -447, -572, -684, -783, -866, -932, -981,-1011,-1022,-1015, -989,	/*  79 */
	  -946, -886, -811, -721, -620, -509, -389, -263, -133,   -1,  129,  258,  382,  500,  609,  708,	/*  95 */
	   796,  870,  931,  977, 1007, 1022, 1020, 1003,  970,  923,  861,  786,  699,  602,  496,  383,	/* 111 */
	   263,  140,   15, -109, -232, -352, -466, -573, -672, -761, -838, -903, -955, -992,-1014,-1022,	/* 127 */
	 -1014, -992, -954, -903, -838, -761, -672, -573, -466, -351, -232, -108,   16,  141,  264,  383,	/* 143 */
	   496,  602,  700,  786,  861,  923,  970, 1003, 1020, 1022, 1007,  977,  931,  870,  796,  708,	/* 159 */
	   609,  500,  382,  258,  129,   -1, -133, -263, -389, -509, -620, -722, -811, -886, -946, -989,	/* 175 */
	 -1015,-1022,-1011, -981, -932, -866, -783, -684, -571, -447, -313, -172,  -26,  120,  266,  407,	/* 191 */
	   540,  662,  771,  863,  936,  988, 1017, 1022, 1002,  957,  887,  794,  678,  543,  392,  228,	/* 207 */
	    56, -120, -294, -462, -618, -755, -869, -954,-1006,-1022, -998, -935, -831, -690, -514, -310,	/* 223 */
	   -86,  147,  380,  597,  784,  926, 1008, 1017,  942,  777,  526,  201, -172, -550, -865,-1020,	/* 239 */
	  -883, -279, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 15 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  407,  965,  980,	/*  15 */
	   693,  276, -157, -532, -810, -974,-1022, -966, -825, -620, -374, -108,  156,  404,  621,  796,	/*  31 */
	   924,  999, 1023,  997,  924,  811,  666,  494,  305,  107,  -91, -284, -464, -626, -764, -874,	/*  47 */
	  -955,-1005,-1022,-1008, -964, -892, -795, -676, -539, -389, -230,  -66,   98,  259,  412,  554,	/*  63 */
	   681,  791,  881,  950,  997, 1020, 1020,  997,  952,  887,  802,  701,  585,  457,  321,  178,	/*  79 */
	    33, -112, -255, -392, -521, -639, -744, -834, -908, -964,-1001,-1020,-1019, -999, -961, -905,	/*  95 */
	  -833, -745, -644, -532, -410, -281, -147,  -11,  124,  257,  386,  508,  621,  723,  812,  886,	/* 111 */
	   946,  989, 1015, 1023, 1014,  987,  944,  884,  810,  722,  621,  510,  390,  264,  133,    0,	/* 127 */
	  -132, -263, -389, -509, -620, -721, -809, -884, -943, -986,-1013,-1022,-1014, -988, -945, -885,	/* 143 */
	  -810, -721, -620, -507, -385, -256, -123,   12,  148,  282,  411,  533,  645,  746,  834,  906,	/* 159 */
	   962, 1000, 1020, 1021, 1002,  965,  909,  835,  744,  639,  521,  393,  255,  113,  -32, -178,	/* 175 */
	  -320, -457, -584, -700, -801, -886, -951, -996,-1019,-1019, -996, -949, -880, -790, -680, -553,	/* 191 */
	  -411, -258,  -97,   67,  231,  390,  540,  677,  796,  893,  965, 1009, 1023, 1005,  956,  875,	/* 207 */
	   764,  626,  465,  285,   92, -107, -305, -493, -665, -811, -923, -996,-1022, -998, -922, -795,	/* 223 */
	  -620, -403, -155,  109,  375,  621,  826,  967, 1023,  974,  811,  533,  157, -275, -692, -979,	/* 239 */
	  -963, -406, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 16 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -526,-1010, -886,	/*  15 */
	  -471,   24,  472,  801,  983, 1019,  926,  733,  472,  176, -125, -407, -648, -835, -959,-1017,	/*  31 */
	 -1010, -942, -821, -658, -462, -246,  -22,  199,  408,  595,  754,  879,  966, 1014, 1021,  989,	/*  47 */
	   921,  820,  691,  540,  371,  192,    8, -173, -349, -512, -658, -783, -884, -958,-1004,-1022,	/*  63 */
	 -1011, -972, -907, -818, -708, -580, -438, -285, -126,   34,  194,  348,  493,  625,  742,  841,	/*  79 */
	   920,  977, 1012, 1023, 1011,  977,  921,  845,  750,  640,  516,  381,  239,   92,  -56, -203,	/*  95 */
	  -345, -480, -605, -717, -813, -893, -955, -997,-1019,-1020,-1001, -962, -904, -827, -735, -628,	/* 111 */
	  -509, -380, -244, -103,   39,  181,  319,  451,  575,  687,  785,  869,  935,  984, 1013, 1023,	/* 127 */
	  1013,  984,  935,  868,  785,  686,  574,  451,  319,  181,   39, -103, -244, -380, -509, -628,	/* 143 */
	  -735, -828, -904, -962,-1001,-1020,-1019, -997, -955, -893, -813, -716, -605, -480, -345, -203,	/* 159 */
	   -56,   92,  239,  381,  516,  640,  750,  845,  921,  977, 1011, 1023, 1012,  977,  920,  841,	/* 175 */
	   742,  625,  492,  348,  193,   34, -126, -285, -438, -580, -708, -818, -907, -972,-1011,-1022,	/* 191 */
	 -1004, -958, -884, -783, -658, -512, -349, -173,    8,  192,  372,  540,  692,  821,  921,  989,	/* 207 */
	  1021, 1014,  966,  879,  754,  595,  407,  198,  -22, -247, -462, -658, -821, -942,-1010,-1017,	/* 223 */
	  -959, -835, -648, -406, -125,  176,  472,  733,  926, 1019,  983,  801,  471,   24, -471, -886,	/* 239 */
	 -1010, -526, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 17 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  638, 1022,  748,	/*  15 */
	   218, -320, -735, -970,-1017, -903, -667, -357,  -18,  310,  596,  818,  961, 1021,  999,  904,	/*  31 */
	   747,  542,  307,   57, -190, -423, -629, -797, -921, -996,-1022, -998, -929, -818, -673, -500,	/*  47 */
	  -309, -106,   97,  295,  481,  646,  785,  895,  972, 1014, 1021,  994,  933,  842,  724,  585,	/*  63 */
	   427,  258,   82,  -95, -269, -433, -584, -718, -830, -918, -980,-1014,-1021,-1000, -952, -879,	/*  79 */
	  -784, -668, -535, -389, -234,  -73,   88,  247,  400,  542,  671,  782,  875,  946,  995, 1020,	/*  95 */
	  1020,  997,  950,  882,  793,  686,  564,  429,  284,  133,  -19, -172, -321, -462, -593, -710,	/* 111 */
	  -812, -895, -958,-1000,-1020,-1018, -993, -946, -879, -792, -688, -569, -438, -297, -150,    0,	/* 127 */
	   151,  298,  439,  570,  689,  793,  880,  947,  994, 1019, 1021, 1001,  959,  896,  812,  711,	/* 143 */
	   594,  463,  322,  173,   20, -133, -283, -428, -563, -685, -792, -881, -950, -996,-1019,-1019,	/* 159 */
	  -994, -945, -874, -781, -669, -541, -399, -246,  -87,   74,  235,  390,  536,  669,  785,  881,	/* 175 */
	   953, 1001, 1022, 1015,  981,  919,  830,  718,  585,  434,  269,   96,  -81, -257, -427, -584,	/* 191 */
	  -724, -841, -932, -993,-1020,-1013, -971, -894, -784, -644, -479, -294,  -96,  108,  310,  501,	/* 207 */
	   674,  819,  930,  999, 1023,  997,  922,  798,  630,  424,  191,  -56, -306, -541, -746, -903,	/* 223 */
	  -998,-1020, -960, -817, -595, -309,   19,  358,  668,  904, 1018,  971,  736,  321, -218, -748,	/* 239 */
	 -1021, -636, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 18 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -736, -997, -570,	/*  15 */
	    50,  590,  924, 1023,  912,  647,  294,  -84, -437, -724, -920,-1014,-1005, -903, -724, -490,	/*  31 */
	  -222,   57,  326,  567,  766,  912,  998, 1023,  987,  897,  758,  581,  376,  154,  -71, -291,	/*  47 */
	  -495, -674, -820, -929, -997,-1022,-1004, -946, -850, -721, -566, -390, -201,   -6,  186,  372,	/*  63 */
	   543,  695,  821,  919,  985, 1019, 1019,  986,  922,  829,  710,  570,  414,  245,   70, -105,	/*  79 */
	  -278, -441, -591, -724, -835, -922, -983,-1016,-1020, -997, -946, -870, -770, -650, -513, -362,	/*  95 */
	  -203,  -38,  126,  288,  442,  584,  711,  819,  906,  970, 1009, 1023, 1011,  973,  912,  827,	/* 111 */
	   722,  599,  462,  313,  156,   -3, -163, -319, -467, -603, -724, -828, -911, -972,-1010,-1022,	/* 127 */
	 -1009, -972, -911, -828, -724, -603, -466, -318, -162,   -3,  157,  313,  462,  599,  722,  827,	/* 143 */
	   912,  973, 1011, 1023, 1009,  970,  906,  819,  710,  584,  442,  288,  126,  -38, -203, -363,	/* 159 */
	  -513, -650, -770, -870, -946, -997,-1020,-1016, -983, -922, -835, -723, -591, -441, -277, -105,	/* 175 */
	    71,  246,  414,  571,  710,  829,  922,  986, 1019, 1019,  985,  919,  821,  694,  543,  372,	/* 191 */
	   186,   -7, -202, -390, -566, -721, -850, -946,-1004,-1022, -997, -929, -820, -674, -495, -291,	/* 207 */
	   -71,  155,  376,  581,  758,  897,  987, 1023,  998,  911,  766,  567,  326,   56, -222, -490,	/* 223 */
	  -725, -903,-1005,-1014, -920, -724, -437,  -84,  295,  648,  912, 1023,  924,  590,   50, -570,	/* 239 */
	  -997, -736, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 19 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  824,  939,  363,	/*  15 */
	  -315, -807,-1015, -949, -677, -288,  131,  512,  804,  976, 1022,  947,  770,  519,  224,  -84,	/*  31 */
	  -378, -634, -833, -964,-1020,-1001, -914, -766, -571, -343,  -97,  151,  387,  599,  775,  907,	/*  47 */
	   991, 1023, 1003,  934,  821,  671,  491,  290,   78, -134, -340, -530, -696, -833, -934, -998,	/*  63 */
	 -1022,-1006, -952, -862, -741, -592, -424, -241,  -50,  141,  326,  500,  655,  788,  893,  969,	/*  79 */
	  1012, 1022,  999,  944,  860,  748,  613,  460,  293,  118,  -60, -236, -404, -560, -699, -816,	/*  95 */
	  -910, -976,-1013,-1021,-1000, -949, -872, -769, -645, -503, -347, -182,  -11,  159,  324,  481,	/* 111 */
	   624,  750,  855,  936,  991, 1019, 1020,  992,  937,  856,  752,  628,  486,  332,  168,    0,	/* 127 */
	  -167, -331, -486, -627, -751, -855, -936, -991,-1019,-1018, -990, -935, -854, -749, -623, -480,	/* 143 */
	  -323, -157,   12,  183,  349,  505,  647,  771,  873,  950, 1001, 1022, 1014,  977,  910,  817,	/* 159 */
	   700,  561,  405,  237,   61, -117, -292, -459, -613, -747, -859, -944, -998,-1021,-1011, -968,	/* 175 */
	  -892, -787, -654, -498, -325, -139,   51,  242,  425,  594,  742,  863,  953, 1007, 1023,  999,	/* 191 */
	   935,  833,  697,  531,  341,  135,  -77, -289, -490, -670, -820, -933,-1002,-1022, -990, -906,	/* 207 */
	  -774, -598, -386, -150,   98,  344,  572,  767,  915, 1002, 1021,  964,  834,  634,  379,   84,	/* 223 */
	  -224, -519, -770, -946,-1021, -975, -802, -511, -130,  290,  679,  950, 1016,  808,  315, -362,	/* 239 */
	  -938, -823, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 20 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -896, -847, -135,	/*  15 */
	   559,  956, 1001,  761,  350, -113, -532, -840,-1000,-1006, -873, -631, -320,   19,  347,  632,	/*  31 */
	   849,  981, 1023,  976,  849,  657,  418,  151, -121, -382, -613, -800, -934,-1008,-1019, -970,	/*  47 */
	  -864, -711, -521, -303,  -72,  160,  382,  583,  754,  887,  976, 1019, 1015,  964,  871,  740,	/*  63 */
	   577,  391,  190,  -17, -224, -419, -597, -750, -872, -960,-1010,-1021, -994, -929, -831, -702,	/*  79 */
	  -548, -375, -189,    2,  193,  376,  546,  697,  823,  920,  987, 1019, 1018,  983,  916,  818,	/*  95 */
	   694,  548,  385,  210,   28, -153, -330, -496, -647, -776, -881, -958,-1006,-1022,-1006, -960,	/* 111 */
	  -884, -781, -654, -507, -345, -172,    4,  182,  354,  515,  660,  785,  887,  962, 1008, 1023,	/* 127 */
	  1008,  962,  887,  785,  660,  514,  353,  181,    4, -173, -345, -507, -654, -781, -884, -960,	/* 143 */
	 -1007,-1022,-1006, -958, -881, -776, -646, -496, -330, -153,   28,  210,  385,  549,  695,  818,	/* 159 */
	   916,  983, 1018, 1019,  986,  920,  822,  696,  546,  376,  193,    2, -189, -375, -548, -702,	/* 175 */
	  -831, -929, -994,-1021,-1010, -960, -872, -749, -597, -419, -223,  -17,  190,  391,  577,  740,	/* 191 */
	   871,  964, 1015, 1019,  976,  887,  754,  583,  382,  159,  -72, -304, -521, -712, -865, -970,	/* 207 */
	 -1019,-1007, -934, -800, -612, -381, -121,  152,  418,  658,  850,  976, 1023,  981,  848,  632,	/* 223 */
	   347,   18, -320, -631, -873,-1006,-1000, -840, -532, -112,  351,  762, 1001,  956,  559, -136,	/* 239 */
	  -847, -896, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 21 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  954,  727,  -96,	/*  15 */
	  -763,-1020, -881, -479,   26,  499,  843, 1009,  990,  810,  513,  152, -217, -550, -809, -969,	/*  31 */
	 -1022, -968, -819, -596, -323,  -25,  268,  535,  756,  916, 1005, 1020,  962,  839,  662,  443,	/*  47 */
	   198,  -55, -303, -531, -725, -875, -975,-1020,-1008, -943, -829, -673, -484, -272,  -48,  176,	/*  63 */
	   390,  585,  752,  882,  972, 1017, 1017,  973,  886,  762,  606,  425,  227,   21, -184, -381,	/*  79 */
	  -563, -721, -850, -945,-1003,-1022,-1002, -944, -850, -725, -573, -400, -213,  -19,  174,  362,	/*  95 */
	   536,  691,  820,  920,  987, 1020, 1017,  978,  905,  802,  670,  516,  345,  162,  -26, -213,	/* 111 */
	  -393, -559, -706, -829, -924, -988,-1019,-1016, -979, -909, -809, -682, -532, -364, -185,    0,	/* 127 */
	   186,  366,  533,  683,  810,  910,  980, 1017, 1020,  989,  925,  830,  707,  559,  393,  213,	/* 143 */
	    26, -161, -344, -516, -670, -801, -905, -977,-1016,-1019, -986, -919, -819, -689, -535, -361,	/* 159 */
	  -173,   20,  215,  401,  574,  726,  851,  945, 1003, 1023, 1004,  946,  851,  721,  563,  382,	/* 175 */
	   184,  -21, -227, -424, -605, -761, -885, -972,-1016,-1016, -971, -881, -750, -584, -389, -174,	/* 191 */
	    49,  273,  485,  674,  830,  944, 1009, 1020,  976,  876,  726,  532,  304,   56, -198, -442,	/* 207 */
	  -661, -839, -961,-1019,-1004, -915, -755, -534, -266,   27,  324,  597,  821,  969, 1023,  970,	/* 223 */
	   809,  551,  218, -152, -512, -809, -989,-1008, -842, -498,  -25,  481,  883, 1021,  764,   97,	/* 239 */
	  -726, -953, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 22 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -993, -579,  326,	/*  15 */
	   915,  996,  671,  141, -398, -805,-1005, -983, -771, -429,  -26,  367,  696,  921, 1019,  988,	/*  31 */
	   842,  603,  304,  -20, -336, -615, -832, -970,-1022, -986, -871, -687, -453, -187,   88,  354,	/*  47 */
	   593,  789,  929, 1007, 1020,  968,  857,  694,  492,  263,   20, -221, -448, -650, -814, -934,	/*  63 */
	 -1004,-1021, -986, -901, -772, -605, -410, -196,   26,  245,  453,  638,  793,  912,  989, 1022,	/*  79 */
	  1010,  953,  856,  722,  558,  371,  169,  -39, -245, -440, -616, -767, -887, -970,-1015,-1019,	/*  95 */
	  -983, -908, -798, -657, -491, -306, -110,   89,  285,  470,  637,  780,  893,  972, 1015, 1020,	/* 111 */
	   988,  918,  815,  681,  523,  345,  155,  -39, -233, -419, -589, -737, -858, -948,-1003,-1022,	/* 127 */
	 -1003, -948, -858, -737, -588, -418, -233,  -39,  156,  346,  523,  682,  815,  918,  988, 1020,	/* 143 */
	  1015,  972,  893,  780,  637,  470,  285,   89, -110, -306, -491, -657, -798, -908, -983,-1019,	/* 159 */
	 -1015, -970, -887, -767, -616, -439, -244,  -38,  169,  371,  558,  722,  856,  953, 1010, 1022,	/* 175 */
	   989,  912,  793,  638,  452,  245,   25, -196, -410, -605, -772, -901, -986,-1021,-1004, -934,	/* 191 */
	  -814, -649, -448, -220,   20,  263,  492,  695,  857,  968, 1020, 1007,  929,  788,  593,  354,	/* 207 */
	    87, -188, -453, -688, -871, -986,-1022, -970, -831, -615, -336,  -19,  304,  603,  842,  988,	/* 223 */
	  1019,  920,  696,  367,  -26, -429, -771, -983,-1005, -805, -398,  141,  672,  997,  915,  325,	/* 239 */
	  -580, -993, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 23 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, 1017,  414, -536,	/*  15 */
	 -1002, -885, -389,  216,  717,  987,  994,  771,  393,  -47, -464, -790, -980,-1017, -908, -679,	/*  31 */
	  -367,  -16,  329,  630,  857,  990, 1021,  950,  791,  561,  284,  -13, -306, -570, -784, -935,	/*  47 */
	 -1012,-1013, -939, -799, -603, -368, -111,  151,  402,  625,  806,  937, 1009, 1020,  971,  865,	/*  63 */
	   711,  517,  295,   59, -178, -405, -609, -780, -909, -991,-1022,-1001, -930, -813, -657, -470,	/*  79 */
	  -261,  -40,  181,  393,  587,  752,  883,  972, 1018, 1017,  971,  882,  754,  594,  408,  205,	/*  95 */
	    -5, -215, -416, -599, -756, -880, -968,-1014,-1019, -981, -902, -787, -639, -465, -273,  -69,	/* 111 */
	   136,  336,  523,  688,  825,  929,  996, 1023, 1008,  954,  861,  734,  578,  398,  203,    0,	/* 127 */
	  -202, -398, -577, -733, -860, -953,-1007,-1022, -995, -928, -824, -687, -521, -335, -134,   71,	/* 143 */
	   274,  466,  640,  788,  903,  982, 1020, 1015,  968,  881,  756,  600,  417,  216,    5, -205,	/* 159 */
	  -408, -594, -754, -881, -970,-1016,-1016, -971, -881, -751, -585, -392, -180,   41,  262,  471,	/* 175 */
	   658,  814,  931, 1002, 1023,  992,  910,  781,  610,  406,  179,  -58, -295, -516, -710, -864,	/* 191 */
	  -970,-1019,-1008, -935, -805, -623, -400, -150,  112,  370,  605,  800,  940, 1014, 1013,  936,	/* 207 */
	   785,  570,  307,   14, -283, -560, -790, -950,-1020, -989, -856, -629, -327,   17,  368,  680,	/* 223 */
	   909, 1018,  981,  791,  465,   47, -393, -770, -993, -986, -715, -214,  391,  886, 1003,  537,	/* 239 */
	  -413,-1016, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 24 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,-1022, -232,  721,	/*  15 */
	  1021,  698,   68, -545, -933,-1013, -808, -409,   68,  514,  844, 1008,  992,  814,  515,  146,	/*  31 */
	  -233, -574, -835, -987,-1019, -933, -746, -483, -173,  149,  452,  709,  897, 1002, 1019,  948,	/*  47 */
	   799,  586,  329,   49, -231, -491, -714, -883, -987,-1022, -986, -885, -725, -519, -281,  -27,	/*  63 */
	   226,  465,  674,  840,  956, 1016, 1016,  957,  845,  686,  490,  268,   32, -203, -427, -628,	/*  79 */
	  -795, -920, -996,-1022, -996, -919, -797, -636, -444, -230,   -7,  216,  428,  620,  781,  905,	/*  95 */
	   987, 1022, 1009,  950,  847,  705,  532,  335,  122,  -94, -306, -505, -681, -825, -933,-1000,	/* 111 */
	 -1022, -999, -932, -824, -680, -506, -310, -101,  112,  320,  515,  687,  829,  935, 1001, 1023,	/* 127 */
	  1001,  935,  829,  686,  514,  320,  111, -101, -311, -506, -680, -824, -932, -999,-1022,-1000,	/* 143 */
	  -933, -825, -680, -505, -306,  -93,  123,  335,  532,  706,  847,  950, 1009, 1022,  987,  905,	/* 159 */
	   781,  620,  428,  216,   -7, -231, -444, -636, -797, -919, -996,-1022, -996, -919, -794, -628,	/* 175 */
	  -427, -203,   33,  268,  490,  687,  845,  958, 1016, 1016,  956,  840,  673,  465,  226,  -27,	/* 191 */
	  -281, -519, -725, -885, -987,-1022, -987, -882, -713, -491, -230,   50,  330,  587,  799,  948,	/* 207 */
	  1019, 1002,  897,  709,  452,  148, -173, -483, -747, -934,-1019, -987, -834, -574, -233,  147,	/* 223 */
	   515,  815,  992, 1008,  844,  514,   67, -410, -809,-1013, -933, -545,   69,  698, 1021,  721,	/* 239 */
	  -232,-1022, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 25 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022, 1010,   44, -866,	/*  15 */
	  -967, -448,  261,  810, 1022,  882,  484,  -28, -514, -864,-1017, -961, -727, -369,   41,  435,	/*  31 */
	   755,  958, 1023,  950,  756,  472,  136, -209, -527, -782, -951,-1021, -987, -858, -648, -382,	/*  47 */
	   -83,  218,  499,  734,  906, 1003, 1019,  955,  818,  621,  379,  111, -162, -422, -651, -833,	/*  63 */
	  -958,-1017,-1009, -935, -801, -617, -395, -150,  102,  348,  571,  759,  902,  991, 1023,  996,	/*  79 */
	   912,  777,  600,  389,  158,  -79, -313, -528, -715, -863, -965,-1016,-1014, -960, -856, -708,	/*  95 */
	  -525, -316,  -91,  137,  359,  562,  737,  876,  971, 1018, 1015,  964,  865,  725,  550,  349,	/* 111 */
	   131,  -92, -311, -515, -694, -840, -946,-1007,-1021, -986, -905, -781, -620, -430, -219,    0,	/* 127 */
	   221,  431,  621,  782,  906,  987, 1022, 1008,  947,  841,  695,  515,  311,   92, -130, -348,	/* 143 */
	  -549, -724, -864, -963,-1014,-1017, -970, -874, -736, -561, -358, -136,   92,  317,  526,  710,	/* 159 */
	   857,  961, 1015, 1017,  966,  864,  716,  529,  313,   80, -158, -389, -599, -776, -911, -995,	/* 175 */
	 -1022, -990, -901, -758, -570, -346, -101,  152,  397,  619,  803,  936, 1010, 1018,  958,  834,	/* 191 */
	   652,  423,  162, -110, -378, -620, -818, -954,-1018,-1002, -905, -733, -497, -217,   85,  383,	/* 207 */
	   650,  859,  988, 1022,  952,  783,  527,  210, -136, -471, -756, -949,-1022, -956, -754, -434,	/* 223 */
	   -39,  370,  728,  963, 1018,  864,  514,   29, -483, -881,-1021, -809, -259,  450,  968,  867,	/* 239 */
	   -43,-1009, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 26 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -979,  147,  967,	/*  15 */
	   847,  161, -561, -974, -967, -610,  -73,  463,  854, 1019,  943,  666,  260, -183, -583, -872,	/*  31 */
	 -1012, -989, -818, -531, -176,  196,  537,  805,  972, 1023,  956,  783,  529,  222, -103, -414,	/*  47 */
	  -682, -881, -996,-1019, -950, -798, -578, -312,  -21,  267,  533,  755,  916, 1006, 1019,  956,	/*  63 */
	   824,  633,  398,  136, -132, -391, -622, -809, -942,-1012,-1015, -954, -831, -657, -442, -201,	/*  79 */
	    50,  299,  528,  725,  878,  979, 1022, 1005,  930,  802,  629,  421,  190,  -51, -289, -510,	/*  95 */
	  -702, -856, -962,-1016,-1014, -959, -851, -699, -510, -294,  -62,  171,  396,  600,  772,  904,	/* 111 */
	   989, 1023, 1003,  932,  814,  653,  459,  242,   13, -216, -435, -631, -796, -919, -996,-1022,	/* 127 */
	  -996, -919, -795, -631, -435, -216,   13,  243,  460,  654,  814,  933, 1003, 1022,  989,  904,	/* 143 */
	   772,  599,  395,  170,  -63, -294, -510, -699, -852, -959,-1015,-1016, -962, -855, -702, -509,	/* 159 */
	  -288,  -50,  190,  421,  630,  803,  930, 1005, 1022,  979,  878,  725,  528,  298,   50, -202,	/* 175 */
	  -443, -657, -832, -954,-1015,-1012, -942, -809, -621, -391, -132,  137,  398,  633,  824,  956,	/* 191 */
	  1019, 1005,  916,  754,  533,  267,  -22, -312, -579, -798, -950,-1019, -996, -881, -682, -414,	/* 207 */
	  -102,  223,  529,  784,  956, 1023,  972,  805,  536,  195, -177, -532, -818, -989,-1012, -872,	/* 223 */
	  -582, -182,  261,  666,  944, 1019,  854,  462,  -73, -611, -967, -974, -561,  162,  848,  967,	/* 239 */
	   146, -979, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 27 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  933, -331,-1017,	/*  15 */
	  -667,  140,  806, 1022,  778,  245, -348, -807,-1014, -943, -638, -194,  279,  683,  944, 1022,	/*  31 */
	   918,  661,  301,  -97, -475, -777, -966,-1021, -942, -745, -459, -122,  224,  542,  796,  961,	/*  47 */
	  1023,  979,  837,  614,  334,   25, -283, -563, -790, -945,-1017,-1002, -903, -730, -499, -229,	/*  63 */
	    56,  336,  588,  794,  939, 1014, 1014,  940,  800,  603,  366,  104, -163, -418, -644, -826,	/*  79 */
	  -952,-1015,-1012, -943, -814, -634, -414, -169,   85,  334,  561,  754,  900,  991, 1023,  994,	/*  95 */
	   905,  763,  577,  358,  118, -127, -366, -582, -765, -904, -991,-1022, -995, -911, -777, -599,	/* 111 */
	  -388, -155,   85,  321,  539,  727,  875,  975, 1020, 1010,  944,  826,  662,  463,  238,    0,	/* 127 */
	  -237, -462, -662, -825, -943,-1009,-1019, -973, -874, -726, -538, -320,  -83,  157,  389,  601,	/* 143 */
	   778,  913,  996, 1023,  992,  905,  766,  583,  366,  128, -117, -357, -577, -763, -904, -993,	/* 159 */
	 -1022, -990, -899, -752, -560, -332,  -84,  170,  415,  635,  815,  944, 1013, 1016,  953,  827,	/* 175 */
	   645,  419,  163, -103, -365, -603, -799, -939,-1013,-1013, -938, -793, -587, -334,  -54,  231,	/* 191 */
	   500,  731,  904, 1003, 1018,  946,  790,  563,  283,  -24, -333, -613, -836, -978,-1022, -959,	/* 207 */
	  -794, -540, -223,  123,  461,  747,  944, 1022,  967,  778,  475,   98, -301, -660, -917,-1021,	/* 223 */
	  -942, -682, -278,  196,  640,  944, 1015,  808,  348, -245, -778,-1021, -804, -139,  668, 1018,	/* 239 */
	   332, -932, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 28 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -869,  506, 1015,	/*  15 */
	   442, -429, -964, -943, -480,  159,  711,  998,  965,  655,  180, -325, -740, -980,-1007, -833,	/*  31 */
	  -503,  -89,  331,  690,  930, 1022,  960,  759,  455,   94, -274, -603, -852, -994,-1016, -920,	/*  47 */
	  -721, -444, -122,  209,  516,  767,  940, 1019,  999,  885,  689,  432,  138, -165, -453, -699,	/*  63 */
	  -884, -994,-1021, -964, -829, -629, -381, -105,  178,  446,  679,  861,  978, 1023,  993,  892,	/*  79 */
	   729,  514,  264,   -2, -268, -514, -725, -886, -987,-1022, -989, -892, -736, -533, -296,  -41,	/*  95 */
	   215,  458,  672,  843,  960, 1018, 1012,  944,  817,  641,  426,  185,  -66, -313, -541, -736,	/* 111 */
	  -886, -983,-1022, -998, -916, -779, -595, -377, -136,  112,  354,  575,  762,  904,  993, 1023,	/* 127 */
	   993,  904,  762,  575,  353,  111, -137, -377, -596, -779, -916, -999,-1022, -983, -886, -736,	/* 143 */
	  -541, -312,  -65,  185,  426,  641,  818,  944, 1012, 1018,  960,  842,  671,  458,  215,  -42,	/* 159 */
	  -297, -534, -737, -892, -990,-1022, -987, -886, -724, -514, -267,   -1,  265,  515,  729,  893,	/* 175 */
	   993, 1023,  978,  860,  679,  446,  177, -105, -382, -630, -830, -964,-1021, -994, -884, -699,	/* 191 */
	  -452, -165,  138,  432,  689,  885,  999, 1019,  939,  767,  515,  208, -123, -445, -721, -920,	/* 207 */
	 -1016, -994, -851, -603, -274,   94,  456,  760,  960, 1022,  930,  689,  331,  -90, -504, -833,	/* 223 */
	 -1007, -979, -740, -325,  180,  655,  965,  998,  710,  158, -481, -943, -963, -428,  443, 1015,	/* 239 */
	   506, -869, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 29 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  792, -662, -958,	/*  15 */
	  -185,  682, 1023,  751,  117, -537, -948, -997, -712, -217,  324,  762,  997,  988,  757,  370,	/*  31 */
	   -84, -512, -836,-1004, -995, -821, -518, -139,  255,  606,  867, 1005, 1007,  877,  637,  321,	/*  47 */
	   -30, -374, -671, -889,-1005,-1011, -908, -711, -442, -130,  192,  493,  744,  922, 1013, 1009,	/*  63 */
	   914,  737,  496,  213,  -86, -377, -634, -836, -969,-1021, -991, -881, -702, -469, -200,   82,	/*  79 */
	   357,  605,  806,  946, 1016, 1011,  932,  787,  585,  342,   76, -194, -450, -674, -851, -969,	/*  95 */
	 -1020,-1002, -915, -767, -568, -331,  -72,  190,  440,  660,  837,  959, 1018, 1011,  938,  805,	/* 111 */
	   620,  396,  146, -112, -363, -591, -781, -921,-1003,-1020, -973, -865, -701, -493, -254,    0,	/* 127 */
	   256,  495,  702,  866,  974, 1021, 1003,  922,  782,  591,  363,  112, -146, -395, -620, -804,	/* 143 */
	  -937,-1010,-1017, -957, -836, -659, -438, -188,   74,  332,  569,  768,  916, 1003, 1021,  970,	/* 159 */
	   852,  675,  451,  194,  -75, -342, -584, -786, -932,-1010,-1015, -945, -805, -604, -356,  -80,	/* 175 */
	   202,  471,  704,  883,  992, 1022,  970,  837,  634,  377,   87, -212, -495, -736, -913,-1008,	/* 191 */
	 -1012, -921, -742, -491, -190,  131,  443,  712,  909, 1012, 1006,  889,  671,  374,   30, -320,	/* 207 */
	  -636, -876,-1006,-1004, -866, -605, -253,  140,  519,  822,  996, 1005,  837,  513,   84, -369,	/* 223 */
	  -757, -987, -996, -761, -322,  218,  713,  998,  949,  538, -116, -751,-1022, -680,  186,  959,	/* 239 */
	   662, -791, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 30 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -698,  796,  853,	/*  15 */
	   -83, -874, -973, -466,  264,  834, 1022,  807,  312, -268, -748, -999, -974, -702, -268,  217,	/*  31 */
	   645,  929, 1023,  919,  647,  264, -156, -545, -840, -999,-1006, -863, -599, -255,  120,  475,	/*  47 */
	   764,  954, 1023,  967,  797,  535,  214, -127, -451, -724, -918,-1013,-1003, -891, -690, -422,	/*  63 */
	  -115,  200,  496,  743,  920, 1011, 1011,  921,  750,  514,  235,  -62, -353, -613, -821, -960,	/*  79 */
	 -1020, -997, -894, -720, -490, -222,   61,  340,  591,  797,  942, 1015, 1012,  934,  787,  582,	/*  95 */
	   335,   65, -209, -468, -692, -867, -979,-1022, -992, -892, -730, -517, -269,   -1,  265,  513,	/* 111 */
	   726,  888,  989, 1023,  987,  883,  719,  506,  259,   -4, -268, -514, -725, -886, -987,-1022,	/* 127 */
	  -987, -886, -724, -513, -268,   -4,  260,  507,  719,  883,  987, 1023,  989,  888,  725,  512,	/* 143 */
	   264,   -2, -269, -518, -731, -893, -992,-1022, -979, -866, -692, -467, -208,   65,  336,  582,	/* 159 */
	   787,  934, 1012, 1015,  941,  797,  591,  339,   60, -223, -491, -721, -894, -997,-1020, -960,	/* 175 */
	  -820, -612, -352,  -61,  235,  514,  750,  921, 1011, 1011,  919,  742,  495,  200, -116, -423,	/* 191 */
	  -691, -891,-1003,-1013, -918, -724, -451, -126,  215,  535,  797,  967, 1023,  953,  764,  474,	/* 207 */
	   119, -255, -600, -864,-1006, -999, -839, -544, -155,  265,  647,  919, 1023,  929,  644,  216,	/* 223 */
	  -269, -703, -974, -999, -747, -267,  312,  807, 1022,  833,  263, -466, -974, -873,  -82,  853,	/* 239 */
	   795, -699, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */
/* 
*/

/* Harmonic table # 31 */

	{-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,-1022,  595, -900, -702,	/*  15 */
	   348,  991,  824,  126, -607, -997, -917, -460,  154,  694,  991,  976,  682,  211, -302, -730,	/*  31 */
	  -979,-1005, -816, -464,  -26,  408,  762,  975, 1017,  890,  621,  258, -139, -511, -804, -980,	/*  47 */
	 -1018, -918, -697, -388,  -32,  323,  637,  871, 1001, 1014,  911,  707,  426,  102, -231, -537,	/*  63 */
	  -786, -952,-1021, -987, -855, -642, -367,  -59,  253,  540,  775,  939, 1017, 1004,  901,  720,	/*  79 */
	   477,  194, -104, -393, -648, -847, -975,-1022, -985, -868, -681, -440, -164,  123,  401,  646,	/*  95 */
	   840,  969, 1022,  996,  894,  724,  499,  237,  -41, -317, -569, -777, -928,-1009,-1015, -947,	/* 111 */
	  -809, -611, -369, -100,  175,  438,  669,  852,  972, 1022,  998,  901,  740,  525,  272,    0,	/* 127 */
	  -272, -524, -739, -901, -997,-1021, -971, -850, -668, -437, -174,  101,  370,  613,  810,  948,	/* 143 */
	  1017, 1010,  929,  778,  569,  318,   42, -237, -499, -723, -893, -995,-1021, -968, -839, -645,	/* 159 */
	  -399, -122,  165,  441,  682,  869,  986, 1023,  976,  847,  648,  394,  105, -193, -476, -720,	/* 175 */
	  -901,-1003,-1016, -938, -774, -538, -251,   60,  368,  643,  857,  988, 1022,  953,  786,  538,	/* 191 */
	   231, -101, -426, -706, -910,-1013,-1000, -870, -635, -322,   34,  389,  698,  919, 1019,  981,	/* 207 */
	   805,  512,  140, -257, -620, -889,-1016, -973, -760, -407,   28,  465,  817, 1006,  980,  731,	/* 223 */
	   303, -210, -682, -975, -990, -693, -153,  461,  918,  998,  607, -125, -824, -990, -346,  703,	/* 239 */
	   901, -594, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 },	/* 255 */

/* Harmonic table # 32 */

	{ 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, -479,  976,  516,	/*  15 */
	  -586,-1021, -587,  231,  867, 1007,  654,   27, -587, -962, -991, -697, -198,  344,  781, 1004,	/*  31 */
	   975,  715,  299, -174, -603, -902,-1021, -945, -697, -330,   89,  488,  803,  986, 1015,  890,	/*  47 */
	   636,  293,  -87, -452, -753, -950,-1022, -962, -783, -508, -173,  178,  507,  775,  953, 1022,	/*  63 */
	   978,  827,  588,  288,  -40, -362, -646, -862, -990,-1020, -949, -785, -547, -258,   53,  360,	/*  79 */
	   631,  843,  978, 1023,  976,  843,  635,  372,   78, -222, -502, -738, -911,-1006,-1016, -941,	/*  95 */
	  -787, -569, -305,  -15,  273,  540,  763,  924, 1010, 1015,  939,  789,  576,  319,   36, -248,	/* 111 */
	  -513, -738, -905,-1001,-1019, -958, -823, -624, -376, -100,  182,  452,  687,  869,  984, 1023,	/* 127 */
	   984,  868,  686,  452,  182, -101, -377, -624, -823, -958,-1019,-1001, -905, -738, -513, -248,	/* 143 */
	    37,  319,  577,  789,  940, 1015, 1010,  923,  763,  540,  273,  -16, -305, -570, -788, -941,	/* 159 */
	 -1016,-1005, -910, -738, -501, -221,   78,  373,  635,  843,  976, 1023,  977,  843,  631,  359,	/* 175 */
	    53, -259, -548, -786, -949,-1020, -990, -862, -645, -362,  -39,  288,  589,  828,  978, 1022,	/* 191 */
	   953,  775,  507,  178, -174, -508, -783, -963,-1022, -950, -752, -452,  -87,  293,  637,  891,	/* 207 */
	  1015,  986,  802,  488,   88, -330, -698, -945,-1021, -902, -602, -174,  299,  716,  975, 1004,	/* 223 */
	   780,  344, -199, -698, -991, -962, -586,   28,  654, 1007,  867,  230, -588,-1021, -586,  516,	/* 239 */
	   975, -480, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023 }	/* 255 */
};
