#!/bin/bash

if [ -z "${1}" -o -z "${2}" ]; then
    echo "usage: mkhd.sh cross-nm elf-file"
    exit 1
fi

CROSS_NM=${1}
ELF_FILE=${2}

${CROSS_NM} --help >/dev/null 2>&1

if [ ${?} -ne 0 ]; then
    echo "error while executing ${CROSS_NM}"
    exit 1
fi

if [ ! -e ${ELF_FILE} ]; then
    echo "${ELF_FILE} does not exist"
    exit 1
fi

getsym() {
    NAME=${1}
    HEX=$(${CROSS_NM} ${ELF_FILE} | grep ' '${NAME}'$' | cut -c -8)
    RET=$(printf '%d' 0x${HEX})
    printf '  %7s  %10s  %6s\n' ${NAME} 0x${HEX} ${RET} >&2
}

echo "creating header for ${ELF_FILE}'s sections:" >&2
echo >&2

getsym _Lo_RAM; SYM_LO_RAM=${RET}
getsym _etext;  SYM_ETEXT=${RET}
getsym _edata;  SYM_EDATA=${RET}
getsym _end;    SYM_END=${RET}

echo >&2

LEN_TEXT=$((${SYM_ETEXT} - ${SYM_LO_RAM}))
LEN_DATA=$((${SYM_EDATA} - ${SYM_ETEXT}))
LEN_BSS=$((${SYM_END} - ${SYM_EDATA}))

out8() {
    VAL8=${1}
    HEX8=$(printf '%x' ${VAL8})
    printf "\x${HEX8}"
}

out16() {
    VAL16=${1}
    HI16=$((VAL16 / 256))
    LO16=$((VAL16 % 256))
    out8 ${HI16}
    out8 ${LO16}
}

out32() {
    VAL32=${1}
    HI32=$((VAL32 / 65536))
    LO32=$((VAL32 % 65536))
    out16 ${HI32}
    out16 ${LO32}
}

out16 24602
out32 ${LEN_TEXT}
out32 ${LEN_DATA}
out32 ${LEN_BSS}
out32 0
out32 0
out32 ${SYM_LO_RAM}
out16 65535
