/*
 *  Copyright (C) 2017 The Contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  A copy of the GNU General Public License can be found in the file
 *  "gpl-v3.txt" in the top directory of this repository.
 */

#include <all.h>

#define ver(...) { \
	if (fpu_verbose) { \
		SDL_LogVerbose(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__); \
	} \
}

bool fpu_verbose = false;

void fpu_init(void)
{
	ver("fpu init");
}

void fpu_quit(void)
{
	ver("fpu quit");
}

void fpu_exec(void)
{
	ver("fpu exec");
}

uint32_t fpu_read(uint32_t off, int32_t sz)
{
	ver("fpu rd 0x%04x:%d", off, sz * 8);
	return 0;
}

void fpu_write(uint32_t off, int32_t sz, uint32_t val)
{
	ver("fpu wr 0x%04x:%d 0x%0*x", off, sz * 8, sz * 2, val);
}
