/*
 *  Copyright (C) 2017 The Contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  A copy of the GNU General Public License can be found in the file
 *  "gpl-v3.txt" in the top directory of this repository.
 */

#include <all.h>

#define ver(...) { \
	if (ser_verbose) { \
		SDL_LogVerbose(SDL_LOG_CATEGORY_APPLICATION, __VA_ARGS__); \
	} \
}

bool ser_verbose = false;

void ser_init(void)
{
	ver("ser init");
}

void ser_quit(void)
{
	ver("ser quit");
}

void ser_exec(void)
{
	ver("ser exec");
}

uint32_t ser_read(uint32_t off, int32_t sz)
{
	ver("ser rd %u:%d", off, sz * 8);
	return 0;
}

void ser_write(uint32_t off, int32_t sz, uint32_t val)
{
	ver("ser wr %u:8 0x%0*x", off, sz * 2, val);
}
