/*
   =============================================================================
	conin.c -- read from the console
	Version 6 -- 1987-06-30 -- D.N. Lynx Crowe
   =============================================================================
*/

#define	_FS_DEF_		/* to avoid unnecessary externals */

#include "biosdefs.h"
#include "io.h"
#include "errno.h"
#include "fcntl.h"
#include "stddefs.h"

extern	void	*memcpy(void *vp1, void *vp2, int16_t n);
extern	int16_t	readbuf(int16_t dev, int8_t *buf);
extern	void	writeln(int16_t unit, int8_t *buf);

int8_t _ConBuf[258];	/* console input buffer */
int16_t _CBused;

int16_t _conin(int8_t *buff, int16_t len)
{
	int16_t 	nbp;
	register int16_t l;

	if (_ConBuf[1] EQ 0) {

		_ConBuf[0] = 255;
		_ConBuf[1] = _ConBuf[2] = 0;

		readbuf(CON_DEV, _ConBuf);
		writeln(CON_DEV, "\r\n");

		if (_ConBuf[2] EQ 0x1a) {

			_ConBuf[1] = 0;
			return(0);
		}

		nbp = ++_ConBuf[1];
		_ConBuf[nbp++ + 1] = '\r';
		_ConBuf[nbp + 1] = '\n';
		_CBused = 2;
	}

	if ((l = _ConBuf[1]) > len)
		l = len;

	memcpy(buff, (_ConBuf + _CBused), l);
	_CBused += l;
	_ConBuf[1] -= l;
	return (l);
}
