/*
   ============================================================================
	io.h -- Buchla 700 I/O library definitions
	Version 12 -- 1987-09-25 -- D.N. Lynx Crowe
   ============================================================================
*/

#include "fspars.h"		/* file system parameters */

struct channel {		/* channel table entry */

	int8_t	c_read;		/* read routine index */
	int8_t	c_write;	/* write routine index */
	int8_t	c_ioctl;	/* ioctl routine index */
	int8_t	c_seek;		/* seek routine index */
	int16_t	(*c_close)();	/* close function pointer */
	io_arg	c_arg;		/* argument to channel driver */
};

struct device {			/* device control structure */

	int8_t	d_read;		/* read routine code */
	int8_t	d_write;	/* write routine code */
	int8_t	d_ioctl;	/* ioctl routine code */
	int8_t	d_seek;		/* seek routine code */
	int16_t	(*d_open)();	/* special open function */
};

struct devtabl {		/* device table entry */

	int8_t	*d_name;	/* device name */
	struct	device	*d_dev;	/* pointer to device structure */
	io_arg	d_arg;		/* argument to device driver */
};

#ifndef	_FS_DEF_

extern	struct channel chantab[MAXCHAN];	/* defined in fsinit.c */
extern	int8_t	Wrkbuf[BPSEC];			/* defined in fsinit.c */

#endif
