/*
 *  Copyright (C) 2017 The Contributors
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  A copy of the GNU General Public License can be found in the file
 *  "gpl.txt" in the top directory of this repository.
 */

#include <all.h>

int32_t sdl_verbose = false;

#define ver(...) _ver(sdl_verbose, 0, __VA_ARGS__)
#define ver2(...) _ver(sdl_verbose, 1, __VA_ARGS__)
#define ver3(...) _ver(sdl_verbose, 2, __VA_ARGS__)

void sdl_init(void)
{
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_EVENTS | SDL_INIT_TIMER) < 0) {
		fprintf(stderr, "SDL_Init() failed: %s\n", SDL_GetError());
		exit(1);
	}

	SDL_LogSetPriority(SDL_LOG_CATEGORY_APPLICATION, SDL_LOG_PRIORITY_VERBOSE);

	if (TTF_Init() < 0) {
		fail("TTF_Init() failed: %s", TTF_GetError());
	}
}

void sdl_quit(void)
{
	TTF_Quit();
	SDL_Quit();
}
