/*
   =============================================================================
	unlink.c -- unlink (delete) a file
	Version 6 -- 1987-11-15 -- D.N. Lynx Crowe
   =============================================================================
*/

#define	DEBUGIT		0

#include "biosdefs.h"
#include "stddefs.h"

#if	DEBUGIT
extern	short	fsdebug;

extern	int	waitcr();
#endif

extern	int16_t	DelFile(struct fcb *fcp);

extern	int16_t fcbinit(int8_t *name, struct fcb *fcp);

/*
   =============================================================================
	unlink(name) -- delete file 'name'.
   =============================================================================
*/

int16_t unlink(int8_t *name)
{
	struct fcb delfcb;

	if (fcbinit(name, &delfcb))
		return(FAILURE);

#if	DEBUGIT
	if (fsdebug) {

		printf("unlink(%s):  deletion FCB created\n", name);
		SnapFCB(&delfcb);
		waitcr();
	}
#endif
	return(DelFile(&delfcb));
}

