/*
   =============================================================================
	etains.c -- MIDAS assignment editor -- instrument to groups
	Version 10 -- 1988-07-11 -- D.N. Lynx Crowe
   =============================================================================
*/

#include "stddefs.h"
#include "fields.h"
#include "vsdd.h"
#include "vsddsw.h"
#include "graphdef.h"

#include "midas.h"
#include "asgdsp.h"

#include "stdio.h"

extern	int8_t	*numblk(int8_t *buf, int16_t n);

extern	void adswin(int16_t n);
extern	void advacur(void);
extern	void setinst(void);
extern	void setv2gi(int16_t group);

extern	uint16_t	*asgob;

extern	int16_t	asgmod;
extern	int16_t	stccol;
extern	int16_t	stcrow;

extern	int8_t	dspbuf[];

extern	int16_t	ins2grp[];

extern	int16_t	adbox[][8];

/* 
*/

/*
   =============================================================================
	modasg() -- indicate that the assignment table was modified
   =============================================================================
*/

void modasg(void)
{
	if (NOT asgmod) {

		asgmod = TRUE;
		adswin(0);
	}
}

/*
   =============================================================================
	et_ains() -- load the edit buffer
   =============================================================================
*/

int16_t et_ains(int16_t n)
{
	register int16_t grp;

	int8_t buf[4];

	grp = 0x00FF & (n >> 8);

	sprintf(ebuf, "%02.2d", ins2grp[grp] & 0x00FF);
	ebflag = TRUE;

	return(SUCCESS);
}

/*
   =============================================================================
	ef_ains() -- parse (unload) the edit buffer
   =============================================================================
*/

int16_t ef_ains(int16_t n)
{
	register int16_t tmpval, grp, i;

	grp = 0x00FF & (n >> 8);
	ebuf[2] = '\0';
	ebflag = FALSE;
	tmpval = 0;

	for (i = 0; i < 2; i++)
		tmpval = (tmpval * 10) + (ebuf[i] - '0');

	if (tmpval GE NINST )
		return(FAILURE);

	ins2grp[grp] = tmpval | (ins2grp[grp] & 0xFF00);
	modasg();
	setv2gi(grp);
	setinst();
	return(SUCCESS);
}

/* 
*/

/*
   =============================================================================
	rd_ains() -- (re)display the field
   =============================================================================
*/

int16_t rd_ains(int16_t nn)
{
	register int16_t n, grp;
	int8_t buf[4];

	n = 0x00FF & nn;
	grp = 0x00FF & (nn >> 8);

	sprintf(dspbuf, "%02.2d", ins2grp[grp] & 0x00FF);

	vbank(0);
	vcputsv(asgob, 64, adbox[n][4], adbox[n][5],
		cfetp->frow, cfetp->flcol, dspbuf, 14);

	return(SUCCESS);
}

/*
   =============================================================================
	nd_ains() -- handle new data entry
   =============================================================================
*/

int16_t nd_ains(int16_t nn, int16_t k)
{
	register int16_t n;

	n = nn & 0xFF;
	ebuf[stccol - cfetp->flcol] = k + '0';
	ebuf[2] = '\0';

	dspbuf[0] = k + '0';
	dspbuf[1] = '\0';

	vbank(0);
	vcputsv(asgob, 64, AK_ENTRY, adbox[n][5],
		stcrow, stccol, dspbuf, 14);

	advacur();
	return(SUCCESS);
}

