/*
   =============================================================================
	etatun.c -- MIDAS assignment editor - tuning table field handlers
	Version 1 -- 1987-12-10 -- D.N. Lynx Crowe
   =============================================================================
*/

#include "stddefs.h"
#include "fields.h"
#include "vsdd.h"
#include "vsddsw.h"
#include "graphdef.h"

#include "midas.h"
#include "asgdsp.h"

#include "stdio.h"

extern void gettun(int16_t n);
extern void modasg(void);

extern	uint16_t	*asgob;

extern	int16_t	stcrow, stccol;
extern	int16_t	curtun;

extern	int16_t	adbox[][8];

extern	int8_t	dspbuf[];

/* 
*/

/*
   =============================================================================
	et_atun() -- load the edit buffer
   =============================================================================
*/

int16_t et_atun(int16_t n)
{
	sprintf(ebuf, "%01.1d", curtun);
	ebflag = TRUE;

	return(SUCCESS);
}

/*
   =============================================================================
	ef_atun() -- parse (unload) the edit buffer
   =============================================================================
*/

int16_t ef_atun(int16_t n)
{
	register int16_t tmpval;

	ebuf[1] = '\0';			/* terminate the string in ebuf */
	ebflag = FALSE;

	tmpval = ebuf[0] - '0';

	gettun(tmpval);

	modasg();
	return(SUCCESS);
}

/* 
*/

/*
   =============================================================================
	rd_atun() -- (re)display the field
   =============================================================================
*/

int16_t rd_atun(int16_t nn)
{
	register int16_t n;

	n = nn & 0xFF;
	sprintf(dspbuf, "Tun %01.1d", curtun);

	vbank(0);
	vcputsv(asgob, 64, adbox[n][4], adbox[n][5],
		adbox[n][6], adbox[n][7], dspbuf, 14);

	return(SUCCESS);
}

/*
   =============================================================================
	nd_atun() -- handle new data entry
   =============================================================================
*/

int16_t nd_atun(int16_t nn, int16_t k)
{
	register int16_t n;

	n = nn & 0xFF;
	ebuf[0] = k + '0';
	ebuf[1] = '\0';

	dspbuf[0] = k + '0';
	dspbuf[1] = '\0';

	vbank(0);
	vcputsv(asgob, 64, AK_ENTRY, adbox[n][5],
		stcrow, stccol, dspbuf, 14);

	return(SUCCESS);
}

