/*
   =============================================================================
	etloc.c -- location field handlers
	Version 11 -- 1988-07-13 -- D.N. Lynx Crowe
   =============================================================================
*/

#include "stddefs.h"
#include "fields.h"
#include "hwdefs.h"
#include "fpu.h"
#include "graphdef.h"
#include "vsdd.h"
#include "vsddsw.h"
#include "score.h"
#include "scfns.h"

#include "midas.h"
#include "scdsp.h"
#include "instdsp.h"

extern	uint16_t	setsr(uint16_t sr);

extern	void advscur(void);
extern	void scupd(void);
extern	void se_disp(struct s_entry *ep, int16_t sd, struct gdsel *gdstb[], int16_t cf);

extern	uint16_t	*obj8;

extern	uint16_t	curintp;

extern	int16_t		ctrsw;
extern	int16_t		timemlt;
extern	int16_t		recsw;
extern	int16_t		stccol;

extern	int16_t		grploc[];
extern	int16_t		grpmode[];
extern	int16_t		grpstat[];
extern	int16_t		loctab[];
extern	int16_t		vce2grp[];

extern	int16_t		expbit[];

extern	struct gdsel	*gdstbc[];

extern	struct instdef	vbufs[];

/* 
*/

/*
   =============================================================================
	et_loc() -- load edit buffer
   =============================================================================
*/

int16_t et_loc(int16_t n)
{
	ebuf[0] =grploc[n] + 1 + '0';
	ebuf[1] = '\0';
	ebflag = TRUE;
	return(SUCCESS);
}

/* 
*/

/*
   =============================================================================
	setloc() -- set location
   =============================================================================
*/

void setloc(int16_t grp, int16_t loc)
{
	register int16_t g, i, val;
	register int32_t ltmp;
	register uint16_t *fpu;
	register struct idfnhdr *fp;
	uint16_t fpmant, fpexp;
	int16_t oldsr;
	int16_t nop;

	grploc[grp] = loc;
	val = (loctab[loc] << 1) ^ 0x8000;
	g = grp + 1;

	fpmant = (((int32_t)curintp & 0x0000FFF0L) *
		  ((int32_t)timemlt & 0x0000FFFFL)) >> 15;

	fpexp = expbit[curintp & 0x000F];

/* 
*/
	for (i = 0; i < 12; i++)
		if (g EQ vce2grp[i]) {

			fp = &vbufs[i].idhfnc[4];
			fpu = io_fpu + FPU_OFNC + (i << 8) + 0x0040;

			oldsr = setsr(0x2200);

/* ++++++++++++++++++++++++++++ FPU interrupts disabled +++++++++++++++++++++ */

			fp->idftmd ^= I_NVBITS;

			*(fpu + (int32_t)FPU_TMNT) = fpmant;
			++nop;	++nop;	++nop;
			*(fpu + (int32_t)FPU_TEXP) = fpexp;
			++nop;	++nop;	++nop;

			if (fp->idftmd & I_VNSUBN)
				*(fpu + (int32_t)FPU_TNV1) = val;
			else
				*(fpu + (int32_t)FPU_TNV0) = val;

			++nop;	++nop;	++nop;

			*(fpu + (int32_t)FPU_TCTL) =
				(fp->idftmd & (I_NRATIO | I_NVBITS)) | 0x0001;

			setsr(oldsr);

/* ++++++++++++++++++++++++++++ Interrupts restored +++++++++++++++++++++++++ */

		}
}

/* 
*/

/*
   =============================================================================
	ef_loc() -- parse edit buffer
   =============================================================================
*/

int16_t ef_loc(int16_t n)
{
	register int16_t ival;
	register struct s_entry *ep;

	ebuf[1] = '\0';
	ival = ebuf[0] - '0';
	ebflag = FALSE;

	if (ival EQ 0)
		return(FAILURE);

	--ival;

	setloc(n, ival);

	if (recsw AND grpstat[n] AND (2 EQ grpmode[n])) {

		if (E_NULL NE (ep = findev(p_cur, t_cur, EV_LOCN, n, -1))) {

			ep->e_data2 = ival;

		} else if (E_NULL NE (ep = e_alc(E_SIZE2))) {

			ep->e_type  = EV_LOCN;
			ep->e_data1 = n;
			ep->e_data2 = ival;
			ep->e_time  = t_cur;
			p_cur = e_ins(ep, ep_adj(p_cur, 0, t_cur))->e_fwd;
			eh_ins(ep, EH_LOCN);
			ctrsw = TRUE;
			se_disp(ep, D_FWD, gdstbc, 1);
			scupd();
		}
	}

	return(SUCCESS);
}

/* 
*/

/*
   =============================================================================
	rd_loc() -- (re)display the field
   =============================================================================
*/

int16_t rd_loc(int16_t n)
{
	if (v_regs[5] & 0x0180)
		vbank(0);

	vputc(obj8, 4, 8+(n*5), (grploc[n] + 1 + '0'), SDW11ATR);

	return(SUCCESS);
}

/*
   =============================================================================
	ds_loc() -- display all location to group assignments
   =============================================================================
*/

void ds_loc(void)
{
	register int16_t i;

	for (i = 0; i < 12; i++)
		rd_loc(i);
}

/* 
*/

/*
   =============================================================================
	nd_loc() -- data entry function
   =============================================================================
*/

int16_t nd_loc(int16_t n, int16_t k)
{
	ebuf[0]  = k + '0';

	if (v_regs[5] & 0x0180)
		vbank(0);

	vputc(obj8, 4, stccol, k + '0', SDW11DEA);
	advscur();

	return(SUCCESS);
}
