/*
   =============================================================================
	ldfield.c -- librarian display field processing and cursor motion
	Version 47 -- 1989-11-15 -- D.N. Lynx Crowe
   =============================================================================
*/

#define	DEBUGIT		0

#include "stddefs.h"
#include "fields.h"
#include "vsdd.h"
#include "graphdef.h"
#include "charset.h"
#include "panel.h"
#include "hwdefs.h"
#include "fpu.h"
#include "curpak.h"

#include "midas.h"
#include "instdsp.h"
#include "libdsp.h"
#include "score.h"

#include "vsddsw.h"

extern	void	select(void);
extern	int16_t	whatbox(void);
extern	void	nokey(void);
extern	int16_t	nonf(int16_t k);
extern	void	cxkstd(void);
extern	void	cykstd(void);
extern	void	stdmkey(void);
extern	int16_t	et_null(int16_t n);
extern	int16_t	ef_null(int16_t n);
extern	int16_t	rd_null(int16_t n);
extern	int16_t	nd_null(int16_t n, int16_t k);
extern	void	lmwclr(void);
extern	void	vcputsv(int16_t *obase, int16_t nw, int16_t fg, int16_t bg, int16_t row, int16_t col, int8_t *str, int16_t pitch);
extern	int16_t	ftkind(int16_t ns);
extern	void	_clsvol(void);
extern	int16_t	lcancel(int16_t lct);
extern	int16_t	stdctp0(void);
extern	int16_t	ldline(int16_t cy);
extern	int16_t	lin2slt(int16_t line);
extern	void	dslslot(int16_t slot, uint16_t fg, int16_t row);
extern	int16_t	putcat(void);
extern	int16_t	showcat(void);
extern	int16_t	showsiz(void);

extern	uint16_t	exp_c(uint16_t c);

extern	void	*memset(void *vp, int8_t c, int16_t n);
extern	int8_t	*slotnam(uint16_t slot, uint16_t kind);

/* 
*/

#if	DEBUGIT
extern	short	debugsw;
#endif

extern	int16_t	astat;
extern	int16_t	catin;
extern	int16_t	cmfirst;
extern	int16_t	cxrate;
extern	int16_t	cxval;
extern	int16_t	cyrate;
extern	int16_t	cyval;
extern	int16_t	ldelsw;
extern	int16_t	lderrsw;
extern	int16_t	ldkind;
extern	int16_t	ldpass;
extern	int16_t	ldrow;
extern	int16_t	ldslot;
extern	int16_t	lmwtype;
extern	int16_t	loadrow;
extern	int16_t	loadsw;
extern	int16_t	lorchl;
extern	int16_t	lrasw;
extern	int16_t	lselsw;
extern	int16_t	ltagged;
extern	int16_t	ndisp;
extern	int16_t	oldltag;
extern	int16_t	oldpk;
extern	int16_t	oldsl;
extern	int16_t	pkctrl;
extern	int16_t	sliders;
extern	int16_t	stcrow;
extern	int16_t	stccol;
extern	int16_t	submenu;
extern	int16_t	tagslot;
extern	int16_t	thcwval;
extern	int16_t	tvcwval;

extern	uint16_t *librob;

extern	int8_t	bfs[];
extern	int8_t	ldfile[];
extern	int8_t	ldcmnt[];

extern	int16_t	crate1[];
extern	int16_t	ldmap[];

extern	LPF	(*swpt)[];
extern	LPF	(*oldsw)[];

extern	struct	selbox	*csbp;
extern	struct	selbox	ldboxes[];

/* forward reference */

void	ld_prmv(void);
void	ldxkey(void);
void	ldmkey(void);
void	ldkey(int16_t k);
void	ldcxupd(void);
void	ldcyupd(void);

extern	int16_t getcat(int16_t msgsw);
extern	int16_t getit(void);
extern	int16_t ocslot(int16_t slot);
extern	int16_t unlink(int8_t *name);
extern	void clrerms(void);
extern	void curset(struct curpak *s);
extern	void dpy_scr(uint16_t color, int16_t ns);
extern	void lcdlbls(void);
extern	void ldswin(int16_t n);
extern	void m7menu(void);
extern	void setleds(void);
extern	void vtcxupd(void);
extern	void vtcyupd(void);

/* 
*/

struct	fet	ld_fet1[] = {

	{21, 10, 17, 0x0000, et_null, ef_null, rd_null, nd_null},  /* name */
	{21, 27, 63, 0x0000, et_null, ef_null, rd_null, nd_null},  /* comment */

	{ 0,  0,  0, 0x0000, FN_NULL, FN_NULL, FN_NULL, FN_NULL}
};

int16_t	ldbox[][8] = {	/* display box parameters */

	{  1,   1, 510,  13, LCFBX00, LCBBX00,  0,  1},	/*  0 - index area label */
	{  1,  14, 510, 292, LCFBX01, LCBBX01,  1,  1},	/*  1 - index area */
	{  1, 294,  78, 307, LCFBX02, LCBBX02, 21,  1},	/*  2 - file name label */
	{ 80, 294, 143, 307, LCFBX03, LCBBX03, 21, 10},	/*  3 - file name */
	{145, 294, 214, 307, LCFBX04, LCBBX04, 21, 19},	/*  4 - comment label */
	{216, 294, 510, 307, LCFBX05, LCBBX05, 21, 27},	/*  5 - comment */
	{  1, 309,  70, 321, LCFBX06, LCBBX06, 22,  1},	/*  6 - fetch */
	{  1, 322,  70, 335, LCFBX07, LCBBX07, 23,  1},	/*  7 - replace / append */
	{  1, 336,  70, 348, LCFBX08, LCBBX08, 24,  1},	/*  8 - lo orch / hi orch */
	{ 72, 309, 255, 348, LCFBX09, LCBBX09, 22, 10},	/*  9 - store */
	{257, 309, 510, 348, LCFBX10, LCBBX10, 22, 33}	/* 10 - message window */
};

int8_t	*ldbxlb0[] = {	/* display box labels */

	"RecrdType L FileName Comment                               Mem", /*  0 */
	"",			/*  1 */
	"FileName",		/*  2 */
	"",			/*  3 */
	"Comment",		/*  4 */
	"",			/*  5 */
	"Index",		/*  6 */
	"",			/*  7 */
	"",			/*  8 */
	"",			/*  9 */
	""			/* 10 */
};

/* 
*/

struct curpak ld_flds = {

	stdctp0,	/* curtype */
	ld_prmv,	/* premove */
	nokey,		/* pstmove */
	cxkstd,		/* cx_key */
	cykstd,		/* cy_key */
	ldcxupd,	/* cx_upd */
	ldcyupd,	/* cy_upd */
	nokey,		/* xy_up */
	nokey,		/* xy_dn */
	ldxkey,		/* x_key */
	select,		/* e_key */
	ldmkey,		/* m_key */
	ldkey,		/* d_key */
	nonf,		/* not_fld */
	ld_fet1,	/* curfet */
	ldboxes,	/* csbp */
	crate1,		/* cratex */
	crate1,		/* cratey */
	CT_TEXT,	/* cmtype */
	LCURX,		/* cxval */
	LCURY		/* cyval */
};

/* 
*/

/*
   =============================================================================
	ldxkey() -- handle the 'X' (delete) key
   =============================================================================
*/

void ldxkey(void)
{
	register int8_t *fn;
	register int16_t slot;
	int8_t buf[4];

	if (NOT astat)		/* only on key closure */
		return; /* FAILURE */

	clrerms();
	stcrow = cyval / 14;
	stccol = cxval >> 3;

	if (lselsw AND lrasw) {

		if (0 NE (slot = ldline(cyval))) {

			slot -= 1;
			ldmap[slot] = -1;
			dpy_scr(ldbox[1][4], slot);
			return; /* SUCCESS */

		} else
			return; /* FAILURE */
	}

	if (lcancel(2))
		return; /* SUCCESS */

	if (NOT ldelsw) {	/* deletion not yet selected ? */

		if (0 NE (ldrow = ldline(cyval))) {	/* index area ? */

			if (stccol EQ 11) {	/* load tag ? */

				if (-1 EQ (slot = lin2slt(stcrow)))
					return; /* FAILURE */

				if (ltagged) {

					if (slot NE tagslot) {

						filecat[tagslot].fcp0 = oldltag;
						ltagged = FALSE;
						showcat();
						return; /* FAILURE */
					}

					putcat();
					ltagged = FALSE;
					showcat();

				} else {

					oldltag = filecat[slot].fcp0;
					filecat[slot].fcp0 = ' ';
					ltagged = TRUE;
					tagslot = slot;

					buf[0] = oldltag;
					buf[1] = '\0';

					if (v_regs[5] & 0x0180)
						vbank(0);

					vcputsv(librob, 64, exp_c(LD_DELC), ldbox[1][5],
						stcrow, 11, buf, 14);
				}

				return; /* SUCCESS */
			}

			if ((stccol < 13) OR (stccol > 20))	/* name ? */
				return; /* FAILURE */

			if (-1 NE (ldslot = lin2slt(ldrow))) {

				/* select file to delete */

				dslslot(ldslot, exp_c(LD_DELC), ldrow);
				ldelsw = TRUE;
				return; /* SUCCESS */
			}
/* 
*/
		} else {	/* not in the index area */

			if (21 EQ stcrow) {	/* filename or comment ? */

				if ((stccol GE 10) AND (stccol LE 17)) {

					/* clear filename field */

					memset(ldfile, ' ', 8);
					ldswin(3);
					return; /* SUCCESS */

				} else if (stccol GE 27) {

					/* clear comment field */

					memset(ldcmnt, ' ', 37);
					ldswin(5);
					return; /* SUCCESS */
				}
			}

			return; /* FAILURE */
		}

/* 
*/

	} else {	/* file selected for deletion */

		/* delete the file if cursor hasn't moved */

		if (ldrow EQ ldline(cyval)) {

			filecat[ldslot].fcsize[0] = 0;
			fn = slotnam(ldslot, ftkind(ldslot));

			unlink(fn);

			ldelsw = FALSE;
			putcat();

			_clsvol();
			showcat();
			showsiz();

			return; /* SUCCESS */
		}

		ldelsw = FALSE;
		showcat();
		return; /* SUCCESS */
	}
}

/* 
*/

/*
   =============================================================================
	ld_prmv() -- librarian cursor pre-move function
   =============================================================================
*/

void ld_prmv(void)
{
	if (lderrsw)		/* clear any error messages in the window */
		clrerms();

	if (ltagged) {		/* clear any non-stored load tag */

		filecat[tagslot].fcp0 = oldltag;
		ltagged = FALSE;
		showcat();
	}
}

/* 
*/

/*
   =============================================================================
	ldcyupd() -- update cursor y location
   =============================================================================
*/

void ldcyupd(void)
{
	if (lmwtype EQ 1) {

		vtcyupd();	/* update virtual typewriter cursor y */

	} else {

		cyval += cyrate;

		if (cyval GT (CYMAX - 1))
			cyval = CYMAX - 1;
		else if (cyval LT 1)
			cyval = 1;
	}
}

/* 
*/

/*
   =============================================================================
	ldcxupd() -- update cursor x location
   =============================================================================
*/

void ldcxupd(void)
{
	if (lmwtype EQ 1 ) {

		vtcxupd();	/* update virtual typewriter cursor x */

	} else {

		cxval += cxrate;

		if (cxval GT (CXMAX - 1))
			cxval = CXMAX - 1;
		else if (cxval LT 1)
			cxval = 1;
	}
}

/* 
*/

/*
   =============================================================================
	ldmkey() -- librarian menu key processor
   =============================================================================
*/

void ldmkey(void)
{
	if (astat) {

		ltagged = FALSE;

		if ((sliders EQ LS_LIBR) OR (pkctrl EQ PK_LIBR)) {

			sliders = oldsl;
			swpt = oldsw;
			pkctrl = oldpk;
			lcdlbls();
			setleds();
		}
	}

	stdmkey();
}

/* 
*/

/*
   =============================================================================
	loadem() -- load multiple files
   =============================================================================
*/

void loadem(int16_t key)
{
	register int16_t c, i, rc, slot;

	rc = FALSE;

	if (getcat(0))				/* get the file catalog */
		return;

	for (ldslot = 0; ldslot < 20; ldslot++) {	/* check each slot */

		if (ocslot(ldslot) AND
		    ((c = filecat[ldslot].fcp0) & 0x007F) EQ (key & 0x007F)) {

			ldkind = ftkind(ldslot);

			if ((ldkind EQ FT_ORC) OR
			    (ldkind EQ FT_ORL) OR
			    (ldkind EQ FT_ORH))
				lorchl = (c & 0x0080) ? 1 : 0;

			if (ldkind EQ FT_SCR)
				for (i = 0; i < N_SCORES; i++)
					ldmap[i] = i;

			if(getit())
				return;

			rc = TRUE;
		}
	}

	if (rc AND (ndisp EQ -1))
		m7menu();
}

/* 
*/

/*
   =============================================================================
	ldkey() -- process data key entry
   =============================================================================
*/

void ldkey(int16_t k)
{
	register int16_t c, col, row, slot;
	int8_t buf[4];

	if (NOT astat)				/* only on key closure */
		return;

	if (NOT catin)				/* catalog must be valid */
		return;

	row = cyval / 14;			/* determine cursor position */
	col = cxval >> 3;

	if (col NE 11)				/* must be column 11 */
		return;

	if (-1 EQ (slot = lin2slt(row)))	/* ... and a valid slot */
		return;

	if (NOT ltagged) {

		oldltag = filecat[slot].fcp0;	/* save old tag */
		lcancel(3);			/* cancel other selections */
	}

/* 
*/
	/* process the key */

	if (k < 7)
		filecat[slot].fcp0 = (c = k + 'A');
	else if (k EQ 7)
		return;
	else if (k EQ 8)
		filecat[slot].fcp0 = (c = filecat[slot].fcp0 & 0x007F);
	else	/* k EQ 9 */
		filecat[slot].fcp0 = (c = filecat[slot].fcp0 | 0x0080);

	loadrow = row;
	tagslot = slot;
	ltagged = TRUE;

	dslslot(slot, exp_c(LD_SELC), row);
	return;
}

/* 
*/

/*
   =============================================================================
	ldfield() -- setup field routines for the librarian
   =============================================================================
*/

void ldfield(void)
{
	lmwtype = 0;
	ltagged = FALSE;
	submenu = FALSE;

	curset(&ld_flds);
}
