#pragma once

#include "biosdefs.h"
#include "stdint.h"

/*
   =============================================================================
	filesys.c -- global variables
   =============================================================================
*/

extern	int32_t		_berrno;
extern	int16_t		_bpbin;
extern	int16_t		_dirin;
extern	int16_t		_dirmod;
extern	struct	dirent	*_dptr;
extern	int16_t		_fatin;
extern	int16_t		_fatmod;
extern	struct	bpb	*_thebpb;
extern	struct	dirent	_thedir[224];
extern	uint16_t	_thefat[7 * 256];

/*
   =============================================================================
	filesys.c -- global functions
   =============================================================================
*/

extern	int16_t		ClsFile(struct fcb *fcp);
extern	int16_t		DelFile(struct fcb *fcp);
extern	int16_t		_alcnew(struct fcb *fcp);
extern	uint16_t	_cl2lsn(struct bpb *bpp, uint16_t clnum);
extern	void		_clsvol(void);
extern	void		_deadio(struct fcb *fcp, int16_t err);
extern	struct	dirent	*_dsnew(void);
extern	struct	dirent	*_dsrch(struct dirent *de);
extern	int16_t		_fmake(struct fcb *fcp);
extern	int16_t		_ftrnc(struct dirent *dp);
extern	uint16_t	_getfat(uint16_t *bufad, uint16_t nfat, struct bpb *bpp);
extern	uint16_t	_gtcl12(int8_t *fat, uint16_t cl);
extern	int16_t		_inifcb(struct fcb *fcp, int8_t *name, int8_t *ext, int16_t mode);
extern	int16_t		_newcls(void);
extern	int16_t		_nsic(struct fcb *fcp, struct bpb *bpp, int8_t *fp);
extern	int16_t		_opfcb(struct fcb *fcp);
extern	int16_t		_opnvol(void);
extern	int16_t		_rdfat(uint16_t *bufad, struct bpb *bpp);
extern	int16_t		_rdroot(uint16_t *buf, struct bpb *bpp);
extern	int16_t		_seek(struct fcb *fcp);
extern	int16_t		fcbinit(int8_t *name, struct fcb *fcp);
