/*
   ============================================================================
	hwdefs.h -- Buchla 700 I/O addresses defined in hwdefs.s
	Version 12 -- 1988-08-15 -- D.N. Lynx Crowe
   ============================================================================
*/

#pragma once
#include "stdint.h"

/* hardware addresses */

extern	uint16_t	io_fpu[];
extern	uint8_t		io_time[];
extern	uint8_t		io_lcd;
extern	uint8_t		io_ser;
extern	uint8_t		io_midi;
extern	uint8_t		io_disk;
extern	uint8_t		io_tone;
extern	uint8_t		io_leds;
extern	uint8_t		io_kbrd;
extern	uint8_t		lcd_a0;
extern	uint8_t		lcd_a1;

extern	uint16_t	io_vreg[];
extern	uint16_t	io_vraw[];
extern	uint16_t	io_vram[];

/* video memory allocations */

extern	uint16_t	v_regs[];
extern	uint16_t	v_odtab[][4];
extern	uint16_t	v_actab[];
extern	uint16_t	v_ct0[];
extern	uint16_t	v_gt1[];
extern	uint16_t	v_score[];
extern	uint16_t	v_cgtab[];

extern	uint16_t	v_curs0[];
extern	uint16_t	v_curs1[];
extern	uint16_t	v_curs2[];
extern	uint16_t	v_curs3[];
extern	uint16_t	v_curs4[];
extern	uint16_t	v_curs5[];
extern	uint16_t	v_curs6[];
extern	uint16_t	v_curs7[];
extern	uint16_t	v_tcur[];
extern	uint16_t	v_kbobj[];
extern	uint16_t	v_lnobj[];
extern	uint16_t	v_win0[];
extern	uint16_t	v_cur[];

/* stuff in the depths of the bios */

extern	int16_t		fc_sw;
extern	int32_t		fc_val;
