/*
   =============================================================================
	stdio.h -- Standard I/O Package header for the Buchla 700
	Version 6 -- 1987-10-20 -- D.N. Lynx Crowe
   =============================================================================
*/

#pragma once
#include "stdint.h"
#include "fspars.h"		/* file system parameters */

#define EOF	-1

#define	fgetc	getc
#define	fputc	putc

#define	_BUSY	0x01
#define	_ALLBUF	0x02
#define	_DIRTY	0x04
#define	_EOF	0x08
#define	_IOERR	0x10

typedef struct {

	int8_t	*_bp;		/* current position in buffer */
	int8_t	*_bend;		/* last character in buffer + 1 */
	int8_t	*_buff;		/* address of buffer */
	int8_t	_flags;		/* {_BUSY, _ALLBUF, _DIRTY, _EOF, _IOERR} */
	int8_t	_unit;		/* fd token returned by open */
	int8_t	_bytbuf;	/* single byte buffer for unbuffered streams */
	int8_t	_pad;		/* pad for alignment -- possibly use later */
	int16_t	_buflen;	/* length of buffer */

} FILE;

#define	stdin	(&Cbuffs[0])
#define	stdout	(&Cbuffs[1])
#define	stderr	(&Cbuffs[2])

#define	getchar()	getc(stdin)
#define	putchar(c)	putc(c, stdout)
#define	feof(fp)	(((fp)->_flags & _EOF) != 0)
#define	ferror(fp)	(((fp)->_flags & _IOERR) != 0)
#define	clearerr(fp)	((fp)->_flags &= ~(_IOERR | _EOF))
#define	fileno(fp)	((fp)->_unit)

#define	O_RDONLY	0x0000	/* Read-only value  */
#define	O_WRONLY	0x0001	/* Write-only value */
#define	O_RDWR		0x0002	/* Read-write value */

#define O_NDELAY	0x0004	/* Non-blocking I/O flag */
#define O_APPEND	0x0008	/* Append mode flag (write only at end) */

#define O_CREAT		0x0100	/* File creation flag (uses 3rd argument) */
#define O_TRUNC		0x0200	/* File truncation flag */
#define O_EXCL		0x0400	/* Exclusive access flag */

#define	O_RAW		0x8000	/* Raw (binary) I/O flag for getc and putc */
